/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.sns.sms;

import io.awspring.cloud.sns.sms.SmsMessageAttributes;
import io.awspring.cloud.sns.sms.SnsSmsOperations;
import org.springframework.lang.Nullable;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.PublishRequest;

public class SnsSmsTemplate
implements SnsSmsOperations {
    private final SnsClient snsClient;

    public SnsSmsTemplate(SnsClient snsClient) {
        this.snsClient = snsClient;
    }

    @Override
    public void send(String phoneNumber, String message, @Nullable SmsMessageAttributes attributes) {
        PublishRequest.Builder publishRequest = PublishRequest.builder().phoneNumber(phoneNumber).message(message);
        if (attributes != null) {
            publishRequest.messageAttributes(attributes.convertAndPopulate());
        }
        this.snsClient.publish((PublishRequest)publishRequest.build());
    }

    @Override
    public void sendToTopicArn(String topicArn, String message, @Nullable SmsMessageAttributes attributes) {
        PublishRequest.Builder publishRequest = PublishRequest.builder().topicArn(topicArn).message(message);
        if (attributes != null) {
            publishRequest.messageAttributes(attributes.convertAndPopulate());
        }
        this.snsClient.publish((PublishRequest)publishRequest.build());
    }
}

