/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.secretsmanager;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.awspring.cloud.core.config.AwsPropertySource;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;

public class SecretsManagerPropertySource
extends AwsPropertySource<SecretsManagerPropertySource, SecretsManagerClient> {
    private static Log LOG = LogFactory.getLog(SecretsManagerPropertySource.class);
    private static final String PREFIX_PART = "?prefix=";
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final String context;
    private final String secretId;
    @Nullable
    private final String prefix;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public SecretsManagerPropertySource(String context, SecretsManagerClient smClient) {
        super("aws-secretsmanager:" + context, (Object)smClient);
        Assert.notNull((Object)context, (String)"context is required");
        this.context = context;
        this.secretId = SecretsManagerPropertySource.resolveSecretId(context);
        this.prefix = SecretsManagerPropertySource.resolvePrefix(context);
    }

    public void init() {
        this.readSecretValue((GetSecretValueRequest)GetSecretValueRequest.builder().secretId(this.secretId).build());
    }

    public String[] getPropertyNames() {
        Set<String> strings = this.properties.keySet();
        return strings.toArray(new String[strings.size()]);
    }

    @Nullable
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    private void readSecretValue(GetSecretValueRequest secretValueRequest) {
        GetSecretValueResponse secretValueResponse = ((SecretsManagerClient)this.source).getSecretValue(secretValueRequest);
        if (secretValueResponse.secretString() != null) {
            try {
                Map secretMap = (Map)this.jsonMapper.readValue(secretValueResponse.secretString(), (TypeReference)new TypeReference<Map<String, Object>>(){});
                for (Map.Entry secretEntry : secretMap.entrySet()) {
                    LOG.debug((Object)("Populating property retrieved from AWS Secrets Manager: " + (String)secretEntry.getKey()));
                    String propertyKey = this.prefix != null ? this.prefix + (String)secretEntry.getKey() : (String)secretEntry.getKey();
                    this.properties.put(propertyKey, secretEntry.getValue());
                }
            }
            catch (JsonParseException e) {
                String[] parts = secretValueResponse.name().split("/");
                String secretName = parts[parts.length - 1];
                LOG.debug((Object)("Populating property retrieved from AWS Secrets Manager: " + secretName));
                String propertyKey = this.prefix != null ? this.prefix + secretName : secretName;
                this.properties.put(propertyKey, secretValueResponse.secretString());
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        } else {
            String[] parts = secretValueResponse.name().split("/");
            String secretName = parts[parts.length - 1];
            LOG.debug((Object)("Populating property retrieved from AWS Secrets Manager: " + secretName));
            String propertyKey = this.prefix != null ? this.prefix + secretName : secretName;
            this.properties.put(propertyKey, secretValueResponse.secretBinary().asByteArray());
        }
    }

    public SecretsManagerPropertySource copy() {
        return new SecretsManagerPropertySource(this.context, (SecretsManagerClient)this.source);
    }

    @Nullable
    String getPrefix() {
        return this.prefix;
    }

    String getContext() {
        return this.context;
    }

    String getSecretId() {
        return this.secretId;
    }

    @Nullable
    private static String resolvePrefix(String context) {
        int prefixIndex = context.indexOf(PREFIX_PART);
        if (prefixIndex != -1) {
            return context.substring(prefixIndex + PREFIX_PART.length());
        }
        return null;
    }

    private static String resolveSecretId(String context) {
        int prefixIndex = context.indexOf(PREFIX_PART);
        if (prefixIndex != -1) {
            return context.substring(0, prefixIndex);
        }
        return context;
    }
}

