/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import io.awspring.cloud.s3.Location;
import io.awspring.cloud.s3.ObjectMetadata;
import io.awspring.cloud.s3.S3ObjectContentTypeResolver;
import io.awspring.cloud.s3.S3OutputStream;
import io.awspring.cloud.s3.UploadFailedException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

abstract class AbstractTempFileS3OutputStream
extends S3OutputStream {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Location location;
    protected final File file;
    protected OutputStream localOutputStream;
    @Nullable
    protected MessageDigest hash;
    @Nullable
    protected final ObjectMetadata objectMetadata;
    protected boolean closed;
    @Nullable
    protected final S3ObjectContentTypeResolver contentTypeResolver;

    AbstractTempFileS3OutputStream(Location location, @Nullable ObjectMetadata objectMetadata) throws IOException {
        this(location, objectMetadata, null);
    }

    AbstractTempFileS3OutputStream(Location location, @Nullable ObjectMetadata objectMetadata, @Nullable S3ObjectContentTypeResolver contentTypeResolver) throws IOException {
        Assert.notNull((Object)location, (String)"Location must not be null.");
        this.location = location;
        this.objectMetadata = objectMetadata;
        this.contentTypeResolver = contentTypeResolver;
        this.file = File.createTempFile("TempFileS3OutputStream", UUID.randomUUID().toString());
        try {
            this.hash = MessageDigest.getInstance("MD5");
            this.localOutputStream = new BufferedOutputStream(new DigestOutputStream(new FileOutputStream(this.file), this.hash));
        }
        catch (NoSuchAlgorithmException e) {
            this.getLogger().warn("Algorithm not available for MD5 hash.", (Throwable)e);
            this.hash = null;
            this.localOutputStream = new BufferedOutputStream(new FileOutputStream(this.file));
        }
        this.closed = false;
    }

    @Override
    public void write(int b) throws IOException {
        this.localOutputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.localOutputStream.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.localOutputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.localOutputStream.flush();
    }

    @Override
    public void abort() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Stream is already closed. Too late to abort.");
        }
        this.localOutputStream.close();
        this.closed = true;
        this.deleteTempFile();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.localOutputStream.close();
        this.closed = true;
        try {
            String contentType;
            PutObjectRequest.Builder builder = PutObjectRequest.builder().bucket(this.location.getBucket()).key(this.location.getObject()).contentLength(Long.valueOf(this.file.length()));
            if (this.objectMetadata != null) {
                this.objectMetadata.apply(builder);
            }
            if (this.hash != null) {
                String contentMD5 = new String(Base64.getEncoder().encode(this.hash.digest()));
                builder = builder.contentMD5(contentMD5);
            }
            if (this.contentTypeResolver != null && (this.objectMetadata == null || this.objectMetadata.getContentType() == null) && (contentType = this.contentTypeResolver.resolveContentType(this.location.getObject())) != null) {
                builder.contentType(contentType);
            }
            this.upload((PutObjectRequest)builder.build());
            this.deleteTempFile();
        }
        catch (Exception se) {
            this.getLogger().error("Failed to upload {}. Temporary file @{}", (Object)this.location.getObject(), (Object)this.file.getPath());
            throw new UploadFailedException(this.file.getPath(), se);
        }
    }

    private void deleteTempFile() {
        boolean result = this.file.delete();
        if (!result) {
            this.getLogger().warn("Temporary file {} could not be deleted", (Object)this.file.getPath());
        }
    }

    protected abstract void upload(PutObjectRequest var1);

    protected Logger getLogger() {
        return this.logger;
    }
}

