/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3.config;

import io.awspring.cloud.core.config.AwsPropertySource;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;

public class S3PropertySource
extends AwsPropertySource<S3PropertySource, S3Client> {
    private static final String YAML_TYPE = "application/x-yaml";
    private static final String YAML_TYPE_ALTERNATIVE = "text/yaml";
    private static final String TEXT_TYPE = "text/plain";
    private static final String JSON_TYPE = "application/json";
    private final String context;
    private final String bucket;
    private final String key;
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public S3PropertySource(String context, S3Client s3Client) {
        super("aws-s3:" + context, (Object)s3Client);
        Assert.notNull((Object)context, (String)"context is required");
        this.context = context;
        this.bucket = this.resolveBucket(context);
        this.key = this.resolveKey(context);
    }

    public void init() {
        this.readPropertySourcesFromS3((GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket).key(this.key).build());
    }

    public S3PropertySource copy() {
        return new S3PropertySource(this.context, (S3Client)this.source);
    }

    public String[] getPropertyNames() {
        return (String[])this.properties.keySet().toArray(String[]::new);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    /*
     * WARNING - void declaration
     */
    private void readPropertySourcesFromS3(GetObjectRequest getObjectRequest) {
        try (ResponseInputStream s3PropertyFileResponse = ((S3Client)this.source).getObject(getObjectRequest);){
            if (s3PropertyFileResponse != null) {
                void var5_11;
                String string = ((GetObjectResponse)s3PropertyFileResponse.response()).contentType();
                int n = -1;
                switch (string.hashCode()) {
                    case 817335912: {
                        if (!string.equals(TEXT_TYPE)) break;
                        boolean bl = false;
                        break;
                    }
                    case 1154967675: {
                        if (!string.equals(YAML_TYPE)) break;
                        boolean bl = true;
                        break;
                    }
                    case -1081755063: {
                        if (!string.equals(YAML_TYPE_ALTERNATIVE)) break;
                        int n2 = 2;
                        break;
                    }
                    case -43840953: {
                        if (!string.equals(JSON_TYPE)) break;
                        int n3 = 3;
                    }
                }
                Properties props = switch (var5_11) {
                    case 0 -> this.readProperties((InputStream)s3PropertyFileResponse);
                    case 1, 2, 3 -> this.readYaml((InputStream)s3PropertyFileResponse);
                    default -> throw new IllegalStateException("Cannot parse unknown content type: " + ((GetObjectResponse)s3PropertyFileResponse.response()).contentType());
                };
                for (Map.Entry entry : props.entrySet()) {
                    this.properties.put(String.valueOf(entry.getKey()), entry.getValue());
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Object)"Exception has happened while trying to close S3InputStream!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Properties readProperties(InputStream inputStream) {
        Properties properties = new Properties();
        try (InputStream in = inputStream;){
            properties.load(in);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot load environment", e);
        }
        return properties;
    }

    private Properties readYaml(InputStream inputStream) {
        Properties properties;
        block8: {
            YamlPropertiesFactoryBean yaml = new YamlPropertiesFactoryBean();
            InputStream in = inputStream;
            try {
                yaml.setResources(new Resource[]{new InputStreamResource(in)});
                properties = yaml.getObject();
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot load environment", e);
                }
            }
            in.close();
        }
        return properties;
    }

    @Nullable
    private String resolveBucket(String context) {
        int delimitedIndex = context.indexOf("/");
        if (delimitedIndex != -1) {
            return context.substring(0, delimitedIndex);
        }
        return null;
    }

    private String resolveKey(String context) {
        int delimitedIndex = context.indexOf("/") + 1;
        return context.substring(delimitedIndex);
    }
}

