/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import io.awspring.cloud.s3.S3Exception;
import io.awspring.cloud.s3.S3ObjectContentTypeResolver;
import java.io.IOException;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class PropertiesS3ObjectContentTypeResolver
implements S3ObjectContentTypeResolver {
    private static final String PROPERTIES_FILE_LOCATION = "/io/awspring/cloud/s3/S3ObjectContentTypeResolver.properties";
    private final Properties properties;

    public PropertiesS3ObjectContentTypeResolver() {
        this(PropertiesS3ObjectContentTypeResolver.loadProperties());
    }

    private static Properties loadProperties() {
        try {
            return PropertiesLoaderUtils.loadProperties((Resource)new ClassPathResource(PROPERTIES_FILE_LOCATION));
        }
        catch (IOException e) {
            throw new S3Exception("Error when loading properties from /io/awspring/cloud/s3/S3ObjectContentTypeResolver.properties for content type resolution", e);
        }
    }

    public PropertiesS3ObjectContentTypeResolver(Properties properties) {
        Assert.notNull((Object)properties, (String)"properties are required");
        this.properties = properties;
    }

    @Override
    public String resolveContentType(String fileName) {
        Assert.notNull((Object)fileName, (String)"fileName is required");
        String extension = this.resolveExtension(fileName);
        if (extension != null) {
            return this.properties.getProperty(extension);
        }
        return null;
    }

    @Nullable
    public String resolveExtension(String fileName) {
        Assert.notNull((Object)fileName, (String)"fileName is required");
        if (fileName.contains(".")) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return null;
    }
}

