/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.messaging.core;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.springframework.messaging.MessageHeaders;

public class SqsMessageHeaders
extends MessageHeaders {
    public static final String SQS_DELAY_HEADER = "delay";
    public static final String SQS_GROUP_ID_HEADER = "message-group-id";
    public static final String SQS_DEDUPLICATION_ID_HEADER = "message-deduplication-id";
    public static final String SQS_APPROXIMATE_FIRST_RECEIVE_TIMESTAMP = "ApproximateFirstReceiveTimestamp";
    public static final String SQS_APPROXIMATE_RECEIVE_COUNT = "ApproximateReceiveCount";
    public static final String SQS_SENT_TIMESTAMP = "SentTimestamp";

    public SqsMessageHeaders(Map<String, Object> headers) {
        super(headers, SqsMessageHeaders.getId(headers), SqsMessageHeaders.getTimestamp(headers));
    }

    public Long getApproximateFirstReceiveTimestamp() {
        return this.containsKey(SQS_APPROXIMATE_FIRST_RECEIVE_TIMESTAMP) ? Long.valueOf(Long.parseLong((String)Objects.requireNonNull(this.get(SQS_APPROXIMATE_FIRST_RECEIVE_TIMESTAMP, String.class)))) : null;
    }

    public Long getSentTimestamp() {
        return SqsMessageHeaders.getTimestamp(this.getRawHeaders());
    }

    public Long getApproximateReceiveCount() {
        return this.containsKey(SQS_APPROXIMATE_RECEIVE_COUNT) ? Long.valueOf(Long.parseLong((String)Objects.requireNonNull(this.get(SQS_APPROXIMATE_RECEIVE_COUNT, String.class)))) : null;
    }

    private static Long getTimestamp(Map<String, Object> headers) {
        return headers.containsKey(SQS_SENT_TIMESTAMP) ? Long.valueOf(Long.parseLong(Objects.requireNonNull((String)headers.get(SQS_SENT_TIMESTAMP)))) : null;
    }

    private static UUID getId(Map<String, Object> headers) {
        return headers.containsKey("id") ? (UUID)headers.get("id") : null;
    }
}

