/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.jdbc.rds;

import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.DBInstanceNotFoundException;
import com.amazonaws.services.rds.model.DescribeDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeDBInstancesResult;
import io.awspring.cloud.core.env.ResourceIdResolver;
import io.awspring.cloud.jdbc.datasource.DataSourceFactory;
import io.awspring.cloud.jdbc.datasource.DataSourceInformation;
import io.awspring.cloud.jdbc.datasource.TomcatJdbcDataSourceFactory;
import io.awspring.cloud.jdbc.datasource.support.DatabaseType;
import java.text.MessageFormat;
import javax.sql.DataSource;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AmazonRdsDataSourceFactoryBean
extends AbstractFactoryBean<DataSource> {
    private final AmazonRDS amazonRds;
    private final String dbInstanceIdentifier;
    private final String password;
    private DataSourceFactory dataSourceFactory = new TomcatJdbcDataSourceFactory();
    private String username;
    private String databaseName;
    private ResourceIdResolver resourceIdResolver;

    public AmazonRdsDataSourceFactoryBean(AmazonRDS amazonRds, String dbInstanceIdentifier, String password) {
        this.amazonRds = amazonRds;
        this.dbInstanceIdentifier = dbInstanceIdentifier;
        this.password = password;
    }

    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setResourceIdResolver(ResourceIdResolver resourceIdResolver) {
        this.resourceIdResolver = resourceIdResolver;
    }

    public Class<DataSource> getObjectType() {
        return DataSource.class;
    }

    protected DataSource createInstance() throws Exception {
        return this.createDataSourceInstance(this.getDbInstanceIdentifier());
    }

    protected void destroyInstance(DataSource instance) throws Exception {
        this.dataSourceFactory.closeDataSource(instance);
    }

    protected DataSource createDataSourceInstance(String identifier) throws Exception {
        DBInstance instance = this.getDbInstance(identifier);
        return this.dataSourceFactory.createDataSource(this.fromRdsInstance(instance));
    }

    protected DBInstance getDbInstance(String identifier) throws IllegalStateException {
        DBInstance instance;
        try {
            DescribeDBInstancesResult describeDBInstancesResult = this.amazonRds.describeDBInstances(new DescribeDBInstancesRequest().withDBInstanceIdentifier(identifier));
            instance = (DBInstance)describeDBInstancesResult.getDBInstances().get(0);
        }
        catch (DBInstanceNotFoundException e) {
            throw new IllegalStateException(MessageFormat.format("No database instance with id:''{0}'' found. Please specify a valid db instance", identifier));
        }
        return instance;
    }

    protected String getDbInstanceIdentifier() {
        return this.resourceIdResolver != null ? this.resourceIdResolver.resolveToPhysicalResourceId(this.dbInstanceIdentifier) : this.dbInstanceIdentifier;
    }

    private DataSourceInformation fromRdsInstance(DBInstance dbInstance) {
        Assert.notNull((Object)dbInstance, (String)"DbInstance must not be null");
        Assert.notNull((Object)dbInstance.getEndpoint(), (String)"The database instance has no endpoint available!");
        return new DataSourceInformation(DatabaseType.fromEngine(dbInstance.getEngine()), dbInstance.getEndpoint().getAddress(), dbInstance.getEndpoint().getPort(), StringUtils.hasText((String)this.databaseName) ? this.databaseName : dbInstance.getDBName(), StringUtils.hasText((String)this.username) ? this.username : dbInstance.getMasterUsername(), this.password);
    }
}

