/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.jdbc.config.annotation;

import io.awspring.cloud.context.config.annotation.ContextDefaultConfigurationRegistrar;
import io.awspring.cloud.context.config.xml.GlobalBeanDefinitionUtils;
import io.awspring.cloud.core.config.AmazonWebserviceClientConfigurationUtils;
import io.awspring.cloud.jdbc.config.annotation.EnableRdsInstance;
import io.awspring.cloud.jdbc.config.annotation.RdsInstanceConfigurerBeanPostProcessor;
import io.awspring.cloud.jdbc.datasource.TomcatJdbcDataSourceFactory;
import io.awspring.cloud.jdbc.rds.AmazonRdsDataSourceFactoryBean;
import io.awspring.cloud.jdbc.rds.AmazonRdsReadReplicaAwareDataSourceFactoryBean;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@Import(value={ContextDefaultConfigurationRegistrar.class})
@Deprecated
public class AmazonRdsInstanceConfiguration {
    @Bean
    public static RdsInstanceConfigurerBeanPostProcessor rdsInstanceConfigurerBeanPostProcessor() {
        return new RdsInstanceConfigurerBeanPostProcessor();
    }

    public static class Registrar
    extends AbstractRegistrar {
        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableRdsInstance.class.getName(), false));
            Assert.notNull((Object)annotationAttributes, (String)("@EnableRdsInstance is not present on importing class " + importingClassMetadata.getClassName()));
            String amazonRdsClientBeanName = AmazonWebserviceClientConfigurationUtils.registerAmazonWebserviceClient((Object)this, (BeanDefinitionRegistry)registry, (String)"com.amazonaws.services.rds.AmazonRDSClient", null, null).getBeanName();
            this.registerDataSource(registry, amazonRdsClientBeanName, annotationAttributes.getString("dbInstanceIdentifier"), annotationAttributes.getString("password"), annotationAttributes.getBoolean("readReplicaSupport"), annotationAttributes.getString("username"), annotationAttributes.getString("databaseName"));
        }
    }

    public static abstract class AbstractRegistrar
    implements ImportBeanDefinitionRegistrar {
        protected void registerDataSource(BeanDefinitionRegistry beanDefinitionRegistry, String amazonRdsClientBeanName, String dbInstanceIdentifier, String password, boolean readReplica, String userName, String databaseName) {
            BeanDefinitionBuilder datasourceBuilder = this.getBeanDefinitionBuilderForDataSource(readReplica);
            datasourceBuilder.addConstructorArgReference(amazonRdsClientBeanName);
            Assert.hasText((String)dbInstanceIdentifier, (String)"The dbInstanceIdentifier can't be empty.");
            datasourceBuilder.addConstructorArgValue((Object)dbInstanceIdentifier);
            Assert.hasText((String)password, (String)"The password can't be empty.");
            datasourceBuilder.addConstructorArgValue((Object)password);
            datasourceBuilder.addPropertyValue("username", (Object)userName);
            datasourceBuilder.addPropertyValue("databaseName", (Object)databaseName);
            String resourceResolverBeanName = GlobalBeanDefinitionUtils.retrieveResourceIdResolverBeanName((BeanDefinitionRegistry)beanDefinitionRegistry);
            datasourceBuilder.addPropertyReference("resourceIdResolver", resourceResolverBeanName);
            datasourceBuilder.addPropertyValue("dataSourceFactory", (Object)BeanDefinitionBuilder.rootBeanDefinition(TomcatJdbcDataSourceFactory.class).getBeanDefinition());
            beanDefinitionRegistry.registerBeanDefinition(dbInstanceIdentifier, (BeanDefinition)datasourceBuilder.getBeanDefinition());
        }

        private BeanDefinitionBuilder getBeanDefinitionBuilderForDataSource(boolean readReplicaEnabled) {
            BeanDefinitionBuilder datasourceBuilder = readReplicaEnabled ? BeanDefinitionBuilder.rootBeanDefinition(AmazonRdsReadReplicaAwareDataSourceFactoryBean.class) : BeanDefinitionBuilder.rootBeanDefinition(AmazonRdsDataSourceFactoryBean.class);
            return datasourceBuilder;
        }
    }
}

