/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.mail.simplemail;

import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.model.RawMessage;
import com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.amazonaws.services.simpleemail.model.SendRawEmailResult;
import io.awspring.cloud.mail.simplemail.SimpleEmailServiceMailSender;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Properties;
import javax.activation.FileTypeMap;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.mail.MailException;
import org.springframework.mail.MailParseException;
import org.springframework.mail.MailPreparationException;
import org.springframework.mail.MailSendException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SimpleEmailServiceJavaMailSender
extends SimpleEmailServiceMailSender
implements JavaMailSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleEmailServiceMailSender.class);
    private static final String SMART_MIME_MESSAGE_CLASS_NAME = "org.springframework.mail.javamail.SmartMimeMessage";
    private Properties javaMailProperties = new Properties();
    private volatile Session session;
    private String defaultEncoding;
    private FileTypeMap defaultFileTypeMap;

    public SimpleEmailServiceJavaMailSender(AmazonSimpleEmailService amazonSimpleEmailService) {
        super(amazonSimpleEmailService);
    }

    protected Properties getJavaMailProperties() {
        return this.javaMailProperties;
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
        this.session = null;
    }

    protected Session getSession() {
        if (this.session == null) {
            this.session = Session.getInstance((Properties)this.getJavaMailProperties());
        }
        return this.session;
    }

    public void setSession(Session session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.session = session;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public void setDefaultFileTypeMap(FileTypeMap defaultFileTypeMap) {
        this.defaultFileTypeMap = defaultFileTypeMap;
    }

    public MimeMessage createMimeMessage() {
        if (ClassUtils.isPresent((String)SMART_MIME_MESSAGE_CLASS_NAME, (ClassLoader)ClassUtils.getDefaultClassLoader())) {
            Class smartMimeMessage = ClassUtils.resolveClassName((String)SMART_MIME_MESSAGE_CLASS_NAME, (ClassLoader)ClassUtils.getDefaultClassLoader());
            Constructor constructor = ClassUtils.getConstructorIfAvailable((Class)smartMimeMessage, (Class[])new Class[]{Session.class, String.class, FileTypeMap.class});
            if (constructor != null) {
                Object mimeMessage = BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{this.getSession(), this.defaultEncoding, this.defaultFileTypeMap});
                return (MimeMessage)mimeMessage;
            }
        }
        return new MimeMessage(this.getSession());
    }

    public MimeMessage createMimeMessage(InputStream contentStream) throws MailException {
        try {
            return new MimeMessage(this.getSession(), contentStream);
        }
        catch (MessagingException e) {
            throw new MailParseException("Could not parse raw MIME content", (Throwable)e);
        }
    }

    public void send(MimeMessage mimeMessage) throws MailException {
        this.send(new MimeMessage[]{mimeMessage});
    }

    public void send(MimeMessage ... mimeMessages) throws MailException {
        HashMap<MimeMessage, Exception> failedMessages = new HashMap<MimeMessage, Exception>();
        for (MimeMessage mimeMessage : mimeMessages) {
            try {
                RawMessage rm = this.createRawMessage(mimeMessage);
                SendRawEmailResult sendRawEmailResult = this.getEmailService().sendRawEmail(new SendRawEmailRequest(rm));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Message with id: {} successfully send", (Object)sendRawEmailResult.getMessageId());
                }
                mimeMessage.setHeader("Message-ID", sendRawEmailResult.getMessageId());
            }
            catch (Exception e) {
                failedMessages.put(mimeMessage, e);
            }
        }
        if (!failedMessages.isEmpty()) {
            throw new MailSendException(failedMessages);
        }
    }

    public void send(MimeMessagePreparator mimeMessagePreparator) throws MailException {
        this.send(new MimeMessagePreparator[]{mimeMessagePreparator});
    }

    public void send(MimeMessagePreparator ... mimeMessagePreparators) throws MailException {
        MimeMessage mimeMessage = this.createMimeMessage();
        for (MimeMessagePreparator mimeMessagePreparator : mimeMessagePreparators) {
            try {
                mimeMessagePreparator.prepare(mimeMessage);
            }
            catch (Exception e) {
                throw new MailPreparationException((Throwable)e);
            }
        }
        this.send(mimeMessage);
    }

    private RawMessage createRawMessage(MimeMessage mimeMessage) {
        ByteArrayOutputStream out;
        try {
            out = new ByteArrayOutputStream();
            mimeMessage.writeTo((OutputStream)out);
        }
        catch (IOException e) {
            throw new MailPreparationException((Throwable)e);
        }
        catch (MessagingException e) {
            throw new MailParseException((Throwable)e);
        }
        return new RawMessage(ByteBuffer.wrap(out.toByteArray()));
    }
}

