/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.core;

import io.awspring.cloud.autoconfigure.AwsAsyncClientCustomizer;
import io.awspring.cloud.autoconfigure.AwsClientCustomizer;
import io.awspring.cloud.autoconfigure.AwsClientProperties;
import io.awspring.cloud.autoconfigure.AwsSyncClientCustomizer;
import io.awspring.cloud.autoconfigure.core.AwsConnectionDetails;
import io.awspring.cloud.autoconfigure.core.AwsProperties;
import io.awspring.cloud.core.SpringCloudClientConfiguration;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsAsyncClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;

public class AwsClientBuilderConfigurer {
    private final AwsCredentialsProvider credentialsProvider;
    private final AwsRegionProvider regionProvider;
    private final AwsProperties awsProperties;
    private final ClientOverrideConfiguration clientOverrideConfiguration;

    public AwsClientBuilderConfigurer(AwsCredentialsProvider credentialsProvider, AwsRegionProvider regionProvider, AwsProperties awsProperties) {
        this.credentialsProvider = credentialsProvider;
        this.regionProvider = regionProvider;
        this.awsProperties = awsProperties;
        this.clientOverrideConfiguration = new SpringCloudClientConfiguration().clientOverrideConfiguration();
    }

    public <T extends AwsClientBuilder<T, ?>> T configure(T builder) {
        return this.configure(builder, null, null, null);
    }

    @Deprecated
    public <T extends AwsClientBuilder<T, ?>> T configure(T builder, @Nullable AwsClientProperties clientProperties, @Nullable io.awspring.cloud.autoconfigure.core.AwsClientCustomizer<T> customizer) {
        return this.configure(builder, clientProperties, null, customizer);
    }

    @Deprecated
    public <T extends AwsClientBuilder<T, ?>> T configure(T builder, @Nullable AwsClientProperties clientProperties, @Nullable AwsConnectionDetails connectionDetails, @Nullable io.awspring.cloud.autoconfigure.core.AwsClientCustomizer<T> customizer) {
        Assert.notNull(builder, (String)"builder is required");
        builder.credentialsProvider(this.credentialsProvider).region(this.resolveRegion(clientProperties, connectionDetails)).overrideConfiguration(this.clientOverrideConfiguration);
        Optional.ofNullable(this.awsProperties.getEndpoint()).ifPresent(arg_0 -> builder.endpointOverride(arg_0));
        Optional.ofNullable(clientProperties).map(AwsClientProperties::getEndpoint).ifPresent(arg_0 -> builder.endpointOverride(arg_0));
        Optional.ofNullable(connectionDetails).map(AwsConnectionDetails::getEndpoint).ifPresent(arg_0 -> builder.endpointOverride(arg_0));
        Optional.ofNullable(this.awsProperties.getDefaultsMode()).ifPresent(arg_0 -> builder.defaultsMode(arg_0));
        Optional.ofNullable(this.awsProperties.getFipsEnabled()).ifPresent(arg_0 -> builder.fipsEnabled(arg_0));
        Optional.ofNullable(this.awsProperties.getDualstackEnabled()).ifPresent(arg_0 -> builder.dualstackEnabled(arg_0));
        Optional.ofNullable(clientProperties).flatMap(it -> Optional.ofNullable(clientProperties.getDualstackEnabled())).ifPresent(arg_0 -> builder.dualstackEnabled(arg_0));
        if (customizer != null) {
            io.awspring.cloud.autoconfigure.core.AwsClientCustomizer.apply(customizer, builder);
        }
        return builder;
    }

    public <T extends AwsClientBuilder<T, ?>> T configureSyncClient(T builder, @Nullable AwsClientProperties clientProperties, @Nullable AwsConnectionDetails connectionDetails, @Nullable Stream<? extends AwsClientCustomizer<T>> clientBuilderCustomizer, @Nullable Stream<? extends AwsSyncClientCustomizer> commonCustomizers) {
        return this.configureSyncClient(builder, clientProperties, connectionDetails, null, clientBuilderCustomizer, commonCustomizers);
    }

    public <T extends AwsClientBuilder<T, ?>> T configureAsyncClient(T builder, @Nullable AwsClientProperties clientProperties, @Nullable AwsConnectionDetails connectionDetails, @Nullable Stream<? extends AwsClientCustomizer<T>> clientBuilderCustomizer, @Nullable Stream<? extends AwsAsyncClientCustomizer> commonCustomizers) {
        return this.configureAsyncClient(builder, clientProperties, connectionDetails, null, clientBuilderCustomizer, commonCustomizers);
    }

    @Deprecated
    public <T extends AwsClientBuilder<T, ?>> T configure(T builder, @Nullable AwsClientProperties clientProperties, @Nullable AwsConnectionDetails connectionDetails, @Nullable io.awspring.cloud.autoconfigure.core.AwsClientCustomizer<T> customizer, @Nullable Stream<? extends AwsClientCustomizer<T>> clientBuilderCustomizer) {
        return this.configure(builder, clientProperties, connectionDetails, null, clientBuilderCustomizer);
    }

    @Deprecated
    public <T extends AwsClientBuilder<T, ?>> T configureSyncClient(T builder, @Nullable AwsClientProperties clientProperties, @Nullable AwsConnectionDetails connectionDetails, @Nullable io.awspring.cloud.autoconfigure.core.AwsClientCustomizer<T> customizer, @Nullable Stream<? extends AwsClientCustomizer<T>> clientBuilderCustomizer, @Nullable Stream<? extends AwsSyncClientCustomizer> commonBuilderCustomizer) {
        AwsClientBuilder result = this.configure(builder, clientProperties, connectionDetails, customizer);
        if (commonBuilderCustomizer != null && builder instanceof AwsSyncClientBuilder) {
            commonBuilderCustomizer.forEach(it -> it.customize((AwsSyncClientBuilder)result));
        }
        if (clientBuilderCustomizer != null) {
            clientBuilderCustomizer.forEach(it -> it.customize(result));
        }
        return result;
    }

    @Deprecated
    public <T extends AwsClientBuilder<T, ?>> T configureAsyncClient(T builder, @Nullable AwsClientProperties clientProperties, @Nullable AwsConnectionDetails connectionDetails, @Nullable io.awspring.cloud.autoconfigure.core.AwsClientCustomizer<T> customizer, @Nullable Stream<? extends AwsClientCustomizer<T>> clientBuilderCustomizer, @Nullable Stream<? extends AwsAsyncClientCustomizer> commonBuilderCustomizer) {
        AwsClientBuilder result = this.configure(builder, clientProperties, connectionDetails, customizer);
        if (commonBuilderCustomizer != null && builder instanceof AwsAsyncClientBuilder) {
            commonBuilderCustomizer.forEach(it -> it.customize((AwsAsyncClientBuilder)result));
        }
        if (clientBuilderCustomizer != null) {
            clientBuilderCustomizer.forEach(it -> it.customize(result));
        }
        return result;
    }

    public Region resolveRegion(@Nullable AwsClientProperties clientProperties, @Nullable AwsConnectionDetails connectionDetails) {
        return AwsClientBuilderConfigurer.resolveRegion(clientProperties, connectionDetails, this.regionProvider);
    }

    public static Region resolveRegion(@Nullable AwsClientProperties clientProperties, @Nullable AwsConnectionDetails connectionDetails, AwsRegionProvider regionProvider) {
        if (connectionDetails != null && StringUtils.hasLength((String)connectionDetails.getRegion())) {
            return Region.of((String)connectionDetails.getRegion());
        }
        if (clientProperties != null && StringUtils.hasLength((String)clientProperties.getRegion())) {
            return Region.of((String)clientProperties.getRegion());
        }
        return regionProvider.getRegion();
    }
}

