/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config;

import io.awspring.cloud.autoconfigure.AwsClientProperties;
import io.awspring.cloud.autoconfigure.core.AwsProperties;
import io.awspring.cloud.autoconfigure.core.CredentialsProperties;
import io.awspring.cloud.autoconfigure.core.CredentialsProviderAutoConfiguration;
import io.awspring.cloud.autoconfigure.core.RegionProperties;
import io.awspring.cloud.autoconfigure.core.RegionProviderAutoConfiguration;
import io.awspring.cloud.core.SpringCloudClientConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.AwsRegionProvider;

public abstract class AbstractAwsConfigDataLocationResolver<T extends ConfigDataResource>
implements ConfigDataLocationResolver<T> {
    protected abstract String getPrefix();

    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        return location.hasPrefix(this.getPrefix());
    }

    public List<T> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        return Collections.emptyList();
    }

    protected <C> void registerAndPromoteBean(ConfigDataLocationResolverContext context, Class<C> type, BootstrapRegistry.InstanceSupplier<C> supplier) {
        this.registerBean(context, type, supplier);
        context.getBootstrapContext().addCloseListener(event -> {
            String name = "configData" + type.getSimpleName();
            Object instance = event.getBootstrapContext().get(type);
            ConfigurableApplicationContext appContext = event.getApplicationContext();
            if (!appContext.getBeanFactory().containsBean(name)) {
                event.getApplicationContext().getBeanFactory().registerSingleton(name, instance);
            }
        });
    }

    protected <C> void registerBean(ConfigDataLocationResolverContext context, Class<C> type, C instance) {
        context.getBootstrapContext().registerIfAbsent(type, BootstrapRegistry.InstanceSupplier.of(instance));
    }

    protected <C> void registerBean(ConfigDataLocationResolverContext context, Class<C> type, BootstrapRegistry.InstanceSupplier<C> supplier) {
        ConfigurableBootstrapContext bootstrapContext = context.getBootstrapContext();
        bootstrapContext.registerIfAbsent(type, supplier);
    }

    protected CredentialsProperties loadCredentialsProperties(Binder binder) {
        return (CredentialsProperties)binder.bind("spring.cloud.aws.credentials", Bindable.of(CredentialsProperties.class)).orElseGet(CredentialsProperties::new);
    }

    protected RegionProperties loadRegionProperties(Binder binder) {
        return (RegionProperties)binder.bind("spring.cloud.aws.region", Bindable.of(RegionProperties.class)).orElseGet(RegionProperties::new);
    }

    protected AwsProperties loadAwsProperties(Binder binder) {
        return (AwsProperties)binder.bind("spring.cloud.aws", Bindable.of(AwsProperties.class)).orElseGet(AwsProperties::new);
    }

    protected List<String> getCustomContexts(String keys) {
        if (StringUtils.hasLength((String)keys)) {
            return Arrays.asList(keys.split(";"));
        }
        return Collections.emptyList();
    }

    protected <T extends AwsClientBuilder<?, ?>> T configure(T builder, AwsClientProperties properties, BootstrapContext context) {
        AwsCredentialsProvider credentialsProvider;
        AwsRegionProvider regionProvider;
        try {
            regionProvider = (AwsRegionProvider)context.get(AwsRegionProvider.class);
        }
        catch (IllegalStateException e) {
            RegionProperties regionProperties = (RegionProperties)context.get(RegionProperties.class);
            regionProvider = RegionProviderAutoConfiguration.createRegionProvider(regionProperties);
        }
        try {
            credentialsProvider = (AwsCredentialsProvider)context.get(AwsCredentialsProvider.class);
        }
        catch (IllegalStateException e) {
            CredentialsProperties credentialsProperties = (CredentialsProperties)context.get(CredentialsProperties.class);
            credentialsProvider = CredentialsProviderAutoConfiguration.createCredentialsProvider(credentialsProperties, regionProvider);
        }
        AwsProperties awsProperties = (AwsProperties)context.get(AwsProperties.class);
        if (StringUtils.hasLength((String)properties.getRegion())) {
            builder.region(Region.of((String)properties.getRegion()));
        } else {
            builder.region(regionProvider.getRegion());
        }
        if (properties.getEndpoint() != null) {
            builder.endpointOverride(properties.getEndpoint());
        } else if (awsProperties.getEndpoint() != null) {
            builder.endpointOverride(awsProperties.getEndpoint());
        }
        builder.credentialsProvider(credentialsProvider);
        builder.overrideConfiguration(new SpringCloudClientConfiguration().clientOverrideConfiguration());
        return builder;
    }
}

