/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.jdbc;

import io.awspring.cloud.core.config.AwsClientProperties;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="cloud.aws.rds")
public class AmazonRdsDatabaseProperties
extends AwsClientProperties {
    static final String PREFIX = "cloud.aws.rds";
    private List<RdsInstance> instances = Collections.emptyList();

    public List<RdsInstance> getInstances() {
        return this.instances;
    }

    public void setInstances(List<RdsInstance> instances) {
        this.instances = instances;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("instances", this.instances).toString();
    }

    public static class RdsInstance {
        private String dbInstanceIdentifier;
        private String username;
        private String databaseName;
        private String password;
        private boolean readReplicaSupport = false;

        public boolean hasRequiredPropertiesSet() {
            return StringUtils.hasLength((String)this.getDbInstanceIdentifier()) && StringUtils.hasLength((String)this.getPassword());
        }

        public String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        public void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean isReadReplicaSupport() {
            return this.readReplicaSupport;
        }

        public void setReadReplicaSupport(boolean readReplicaSupport) {
            this.readReplicaSupport = readReplicaSupport;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RdsInstance that = (RdsInstance)o;
            return Objects.equals(this.dbInstanceIdentifier, that.dbInstanceIdentifier);
        }

        public int hashCode() {
            return Objects.hash(this.dbInstanceIdentifier, this.username, this.databaseName, this.password, this.readReplicaSupport);
        }
    }
}

