/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer.lang;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.TypeSerializer;

public class DoubleArraySerializer
implements TypeSerializer<double[]> {
    @Override
    public void write(double[] doubles, BufferOutput buffer, Serializer serializer) {
        buffer.writeUnsignedShort(doubles.length);
        for (double d : doubles) {
            buffer.writeDouble(d);
        }
    }

    @Override
    public double[] read(Class<double[]> type, BufferInput buffer, Serializer serializer) {
        double[] doubles = new double[buffer.readUnsignedShort()];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = buffer.readDouble();
        }
        return doubles;
    }
}

