/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.ByteBufferBytes;
import io.atomix.catalyst.buffer.Bytes;
import io.atomix.catalyst.buffer.CatalystIOException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;

public class MappedBytes
extends ByteBufferBytes {
    private final File file;
    private final RandomAccessFile randomAccessFile;
    private final FileChannel.MapMode mode;

    public static MappedBytes allocate(File file, long size) {
        return MappedBytes.allocate(file, FileChannel.MapMode.READ_WRITE, size);
    }

    public static MappedBytes allocate(File file, FileChannel.MapMode mode, long size) {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        if (mode == null) {
            mode = FileChannel.MapMode.READ_WRITE;
        }
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size for MappedBytes cannot be greater than 2147483647");
        }
        RandomAccessFile randomAccessFile = MappedBytes.createFile(file, mode);
        try {
            MappedByteBuffer buffer = randomAccessFile.getChannel().map(mode, 0L, size);
            return new MappedBytes(file, randomAccessFile, buffer, mode);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    protected MappedBytes(File file, RandomAccessFile randomAccessFile, MappedByteBuffer buffer, FileChannel.MapMode mode) {
        super(buffer);
        this.file = file;
        this.randomAccessFile = randomAccessFile;
        this.mode = mode;
    }

    @Override
    protected ByteBuffer newByteBuffer(long size) {
        try {
            return this.randomAccessFile.getChannel().map(this.mode, 0L, size);
        }
        catch (IOException e) {
            throw new CatalystIOException(e);
        }
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public Bytes flush() {
        ((MappedByteBuffer)this.buffer).force();
        return this;
    }

    @Override
    public void close() {
        try {
            this.randomAccessFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.close();
    }

    public void delete() {
        try {
            this.close();
            Files.delete(this.file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static RandomAccessFile createFile(File file, FileChannel.MapMode mode) {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        if (mode == null) {
            mode = FileChannel.MapMode.READ_WRITE;
        }
        try {
            return new RandomAccessFile(file, MappedBytes.parseMode(mode));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String parseMode(FileChannel.MapMode mode) {
        if (mode == FileChannel.MapMode.READ_ONLY) {
            return "r";
        }
        if (mode == FileChannel.MapMode.READ_WRITE) {
            return "rw";
        }
        throw new IllegalArgumentException("unsupported map mode");
    }
}

