/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.AbstractBytes;
import io.atomix.catalyst.buffer.Bytes;
import io.atomix.catalyst.util.Assert;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class ByteBufferBytes
extends AbstractBytes {
    protected ByteBuffer buffer;

    protected ByteBufferBytes(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public Bytes reset(ByteBuffer buffer) {
        buffer.clear();
        this.buffer = (ByteBuffer)Assert.notNull((Object)buffer, (String)"buffer");
        return this;
    }

    protected abstract ByteBuffer newByteBuffer(long var1);

    @Override
    public Bytes resize(long newSize) {
        ByteBuffer oldBuffer = this.buffer;
        ByteBuffer newBuffer = this.newByteBuffer(newSize);
        oldBuffer.position(0).limit(this.buffer.capacity());
        newBuffer.position(0).limit(this.buffer.capacity());
        newBuffer.put(oldBuffer);
        newBuffer.clear();
        return this.reset(newBuffer);
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    public ByteBuffer byteBuffer() {
        return this.buffer;
    }

    @Override
    public Bytes zero() {
        return this;
    }

    @Override
    public long size() {
        return this.buffer.capacity();
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public Bytes order(ByteOrder order) {
        return this.reset(this.buffer.order(order));
    }

    private int index(long offset) {
        return (int)offset;
    }

    @Override
    public Bytes zero(long offset) {
        for (int i = this.index(offset); i < this.buffer.capacity(); ++i) {
            this.buffer.put(i, (byte)0);
        }
        return this;
    }

    @Override
    public Bytes zero(long offset, long length) {
        int i = this.index(offset);
        while ((long)i < offset + length) {
            this.buffer.put(i, (byte)0);
            ++i;
        }
        return this;
    }

    @Override
    public Bytes read(long position, byte[] bytes, long offset, long length) {
        int i = 0;
        while ((long)i < length) {
            bytes[this.index((long)offset) + i] = (byte)this.readByte(position + (long)i);
            ++i;
        }
        return this;
    }

    @Override
    public Bytes read(long position, Bytes bytes, long offset, long length) {
        int i = 0;
        while ((long)i < length) {
            bytes.writeByte(offset + (long)i, this.readByte(position + (long)i));
            ++i;
        }
        return this;
    }

    @Override
    public Bytes write(long position, byte[] bytes, long offset, long length) {
        int i = 0;
        while ((long)i < length) {
            this.buffer.put((int)position + i, bytes[this.index(offset) + i]);
            ++i;
        }
        return this;
    }

    @Override
    public Bytes write(long position, Bytes bytes, long offset, long length) {
        int i = 0;
        while ((long)i < length) {
            this.buffer.put((int)position + i, (byte)bytes.readByte(offset + (long)i));
            ++i;
        }
        return this;
    }

    @Override
    public int readByte(long offset) {
        return this.buffer.get(this.index(offset));
    }

    @Override
    public char readChar(long offset) {
        return this.buffer.getChar(this.index(offset));
    }

    @Override
    public short readShort(long offset) {
        return this.buffer.getShort(this.index(offset));
    }

    @Override
    public int readInt(long offset) {
        return this.buffer.getInt(this.index(offset));
    }

    @Override
    public long readLong(long offset) {
        return this.buffer.getLong(this.index(offset));
    }

    @Override
    public float readFloat(long offset) {
        return this.buffer.getFloat(this.index(offset));
    }

    @Override
    public double readDouble(long offset) {
        return this.buffer.getDouble(this.index(offset));
    }

    @Override
    public Bytes writeByte(long offset, int b) {
        this.buffer.put(this.index(offset), (byte)b);
        return this;
    }

    @Override
    public Bytes writeChar(long offset, char c) {
        this.buffer.putChar(this.index(offset), c);
        return this;
    }

    @Override
    public Bytes writeShort(long offset, short s) {
        this.buffer.putShort(this.index(offset), s);
        return this;
    }

    @Override
    public Bytes writeInt(long offset, int i) {
        this.buffer.putInt(this.index(offset), i);
        return this;
    }

    @Override
    public Bytes writeLong(long offset, long l) {
        this.buffer.putLong(this.index(offset), l);
        return this;
    }

    @Override
    public Bytes writeFloat(long offset, float f) {
        this.buffer.putFloat(this.index(offset), f);
        return this;
    }

    @Override
    public Bytes writeDouble(long offset, double d) {
        this.buffer.putDouble(this.index(offset), d);
        return this;
    }
}

