/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer.util;

import io.atomix.catalyst.buffer.util.MappedMemory;
import io.atomix.catalyst.buffer.util.MemoryAllocator;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;

public class MappedMemoryAllocator
implements MemoryAllocator<MappedMemory> {
    public static final FileChannel.MapMode DEFAULT_MAP_MODE = FileChannel.MapMode.READ_WRITE;
    private final AtomicInteger referenceCount = new AtomicInteger();
    private final RandomAccessFile file;
    private final FileChannel channel;
    private final FileChannel.MapMode mode;
    private final long offset;

    public MappedMemoryAllocator(File file) {
        this(file, DEFAULT_MAP_MODE, 0L);
    }

    public MappedMemoryAllocator(File file, FileChannel.MapMode mode) {
        this(file, mode, 0L);
    }

    public MappedMemoryAllocator(File file, FileChannel.MapMode mode, long offset) {
        this(MappedMemoryAllocator.createFile(file, mode), mode, offset);
    }

    public MappedMemoryAllocator(RandomAccessFile file, FileChannel.MapMode mode, long offset) {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        if (mode == null) {
            throw new NullPointerException("mode cannot be null");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("offset cannot be negative");
        }
        this.file = file;
        this.channel = this.file.getChannel();
        this.mode = mode;
        this.offset = offset;
    }

    private static RandomAccessFile createFile(File file, FileChannel.MapMode mode) {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        if (mode == null) {
            mode = DEFAULT_MAP_MODE;
        }
        try {
            return new RandomAccessFile(file, MappedMemoryAllocator.parseMode(mode));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String parseMode(FileChannel.MapMode mode) {
        if (mode == FileChannel.MapMode.READ_ONLY) {
            return "r";
        }
        if (mode == FileChannel.MapMode.READ_WRITE) {
            return "rw";
        }
        throw new IllegalArgumentException("unsupported map mode");
    }

    @Override
    public MappedMemory allocate(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("mapped memory size cannot be greater than 2147483647");
        }
        try {
            if (this.file.length() < size) {
                this.file.setLength(size);
            }
            this.referenceCount.incrementAndGet();
            return new MappedMemory(this.channel.map(this.mode, this.offset, size), this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MappedMemory reallocate(MappedMemory memory, long size) {
        MappedMemory newMemory = this.allocate(size);
        memory.free();
        return newMemory;
    }

    void release() {
        if (this.referenceCount.decrementAndGet() == 0) {
            try {
                this.file.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

