/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer.util;

import io.atomix.catalyst.buffer.util.HeapMemoryAllocator;
import io.atomix.catalyst.buffer.util.Memory;
import io.atomix.catalyst.buffer.util.NativeMemory;
import sun.misc.Unsafe;

public class HeapMemory
implements Memory {
    public static final long ARRAY_BASE_OFFSET = NativeMemory.UNSAFE.arrayBaseOffset(byte[].class);
    public static final long MAX_SIZE = Integer.MAX_VALUE;
    private final HeapMemoryAllocator allocator;
    private byte[] array;

    public static HeapMemory allocate(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size cannot be greater than 2147483647");
        }
        return new HeapMemoryAllocator().allocate(size);
    }

    public static HeapMemory wrap(byte[] bytes) {
        return new HeapMemory(bytes, new HeapMemoryAllocator());
    }

    public HeapMemory(byte[] array, HeapMemoryAllocator allocator) {
        if (array == null) {
            throw new NullPointerException("array cannot be null");
        }
        if (allocator == null) {
            throw new NullPointerException("allocator cannot be null");
        }
        this.allocator = allocator;
        this.array = array;
    }

    @Override
    public HeapMemoryAllocator allocator() {
        return this.allocator;
    }

    @Override
    public final long address() {
        throw new UnsupportedOperationException();
    }

    public HeapMemory reset(byte[] array) {
        this.array = array;
        return this;
    }

    @Override
    public final long address(long offset) {
        return ARRAY_BASE_OFFSET + offset;
    }

    @Override
    public long size() {
        return this.array.length;
    }

    public Unsafe unsafe() {
        return NativeMemory.UNSAFE;
    }

    public final byte[] array() {
        return this.array;
    }

    public final long offset() {
        return ARRAY_BASE_OFFSET;
    }

    @Override
    public HeapMemory copy() {
        HeapMemory copy = this.allocator.allocate(this.array.length);
        NativeMemory.UNSAFE.copyMemory(this.array, ARRAY_BASE_OFFSET, copy.array, ARRAY_BASE_OFFSET, this.array.length);
        return copy;
    }

    @Override
    public byte getByte(long offset) {
        return NativeMemory.UNSAFE.getByte(this.array, this.address(offset));
    }

    @Override
    public char getChar(long offset) {
        return NativeMemory.UNSAFE.getChar(this.array, this.address(offset));
    }

    @Override
    public short getShort(long offset) {
        return NativeMemory.UNSAFE.getShort(this.array, this.address(offset));
    }

    @Override
    public int getInt(long offset) {
        return NativeMemory.UNSAFE.getInt(this.array, this.address(offset));
    }

    @Override
    public long getLong(long offset) {
        return NativeMemory.UNSAFE.getLong(this.array, this.address(offset));
    }

    @Override
    public float getFloat(long offset) {
        return NativeMemory.UNSAFE.getFloat(this.array, this.address(offset));
    }

    @Override
    public double getDouble(long offset) {
        return NativeMemory.UNSAFE.getDouble(this.array, this.address(offset));
    }

    @Override
    public void putByte(long offset, byte b) {
        NativeMemory.UNSAFE.putByte(this.array, this.address(offset), b);
    }

    @Override
    public void putChar(long offset, char c) {
        NativeMemory.UNSAFE.putChar(this.array, this.address(offset), c);
    }

    @Override
    public void putShort(long offset, short s) {
        NativeMemory.UNSAFE.putShort(this.array, this.address(offset), s);
    }

    @Override
    public void putInt(long offset, int i) {
        NativeMemory.UNSAFE.putInt(this.array, this.address(offset), i);
    }

    @Override
    public void putLong(long offset, long l) {
        NativeMemory.UNSAFE.putLong(this.array, this.address(offset), l);
    }

    @Override
    public void putFloat(long offset, float f) {
        NativeMemory.UNSAFE.putFloat(this.array, this.address(offset), f);
    }

    @Override
    public void putDouble(long offset, double d) {
        NativeMemory.UNSAFE.putDouble(this.array, this.address(offset), d);
    }

    @Override
    public void clear() {
        NativeMemory.UNSAFE.setMemory(this.array, ARRAY_BASE_OFFSET, this.array.length, (byte)0);
    }

    @Override
    public void free() {
        this.clear();
    }
}

