/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.concurrent;

import com.google.common.base.Preconditions;
import io.atomix.utils.concurrent.BlockingAwareSingleThreadContext;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.concurrent.Threads;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;

public class BlockingAwareSingleThreadContextFactory
implements ThreadContextFactory {
    private final ThreadFactory threadFactory;
    private final Executor threadPoolExecutor;

    public BlockingAwareSingleThreadContextFactory(String nameFormat, int threadPoolSize, Logger logger) {
        this(threadPoolSize, Threads.namedThreads(nameFormat, logger));
    }

    public BlockingAwareSingleThreadContextFactory(int threadPoolSize, ThreadFactory threadFactory) {
        this(threadFactory, Executors.newScheduledThreadPool(threadPoolSize, threadFactory));
    }

    public BlockingAwareSingleThreadContextFactory(ThreadFactory threadFactory, Executor threadPoolExecutor) {
        this.threadFactory = (ThreadFactory)Preconditions.checkNotNull((Object)threadFactory);
        this.threadPoolExecutor = (Executor)Preconditions.checkNotNull((Object)threadPoolExecutor);
    }

    @Override
    public ThreadContext createContext() {
        return new BlockingAwareSingleThreadContext(this.threadFactory, this.threadPoolExecutor);
    }
}

