/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.serializer;

import io.atomix.utils.Builder;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Namespaces;
import io.atomix.utils.serializer.Serializer;

public class SerializerBuilder
implements Builder<Serializer> {
    private final String name;
    private final Namespace.Builder namespaceBuilder = Namespace.builder().register(Namespaces.BASIC).nextId(500);

    public SerializerBuilder() {
        this(null);
    }

    public SerializerBuilder(String name) {
        this.name = name;
    }

    public SerializerBuilder withRegistrationRequired() {
        return this.withRegistrationRequired(true);
    }

    public SerializerBuilder withRegistrationRequired(boolean registrationRequired) {
        this.namespaceBuilder.setRegistrationRequired(registrationRequired);
        return this;
    }

    public SerializerBuilder withCompatibleSerialization() {
        return this.withCompatibleSerialization(true);
    }

    public SerializerBuilder withCompatibleSerialization(boolean compatibleSerialization) {
        this.namespaceBuilder.setCompatible(compatibleSerialization);
        return this;
    }

    public SerializerBuilder withNamespace(Namespace namespace) {
        this.namespaceBuilder.register(namespace);
        return this;
    }

    public SerializerBuilder withTypes(Class<?> ... types) {
        this.namespaceBuilder.register(types);
        return this;
    }

    public SerializerBuilder addType(Class<?> type) {
        this.namespaceBuilder.register(type);
        return this;
    }

    public SerializerBuilder addSerializer(com.esotericsoftware.kryo.Serializer serializer, Class<?> ... types) {
        this.namespaceBuilder.register(serializer, types);
        return this;
    }

    @Override
    public Serializer build() {
        return Serializer.using(this.name != null ? this.namespaceBuilder.build(this.name) : this.namespaceBuilder.build());
    }
}

