/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.logging;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.function.Supplier;

public class LoggerContext {
    private final Supplier<String> stringProvider;

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static Builder builder(Class clazz) {
        return new Builder(clazz.getSimpleName());
    }

    public LoggerContext(Supplier<String> stringProvider) {
        this.stringProvider = stringProvider;
    }

    public String toString() {
        return this.stringProvider.get();
    }

    public static class Builder
    implements io.atomix.utils.Builder<LoggerContext> {
        private final MoreObjects.ToStringHelper identityStringHelper;
        private MoreObjects.ToStringHelper argsStringHelper;
        private boolean omitNullValues = false;

        public Builder(String name) {
            this.identityStringHelper = MoreObjects.toStringHelper((String)name);
        }

        private void initializeArgs() {
            if (this.argsStringHelper == null) {
                this.argsStringHelper = MoreObjects.toStringHelper((String)"");
            }
        }

        @CanIgnoreReturnValue
        public Builder omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder add(String name, Object value) {
            this.initializeArgs();
            this.argsStringHelper.add(name, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder add(String name, boolean value) {
            this.initializeArgs();
            this.argsStringHelper.add(name, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder add(String name, char value) {
            this.initializeArgs();
            this.argsStringHelper.add(name, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder add(String name, double value) {
            this.initializeArgs();
            this.argsStringHelper.add(name, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder add(String name, float value) {
            this.initializeArgs();
            this.argsStringHelper.add(name, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder add(String name, int value) {
            this.initializeArgs();
            this.argsStringHelper.add(name, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder add(String name, long value) {
            this.initializeArgs();
            this.argsStringHelper.add(name, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addValue(Object value) {
            this.identityStringHelper.addValue(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addValue(boolean value) {
            this.identityStringHelper.addValue(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addValue(char value) {
            this.identityStringHelper.addValue(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addValue(double value) {
            this.identityStringHelper.addValue(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addValue(float value) {
            this.identityStringHelper.addValue(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addValue(int value) {
            this.identityStringHelper.addValue(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addValue(long value) {
            this.identityStringHelper.addValue(value);
            return this;
        }

        @Override
        public LoggerContext build() {
            MoreObjects.ToStringHelper identityStringHelper = this.identityStringHelper;
            MoreObjects.ToStringHelper argsStringHelper = this.argsStringHelper;
            if (this.omitNullValues) {
                identityStringHelper.omitNullValues();
                if (argsStringHelper != null) {
                    argsStringHelper.omitNullValues();
                }
            }
            return new LoggerContext(() -> {
                if (argsStringHelper == null) {
                    return identityStringHelper.toString();
                }
                return identityStringHelper.toString() + argsStringHelper.toString();
            });
        }
    }
}

