/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils;

import com.google.common.base.MoreObjects;
import java.lang.reflect.Array;
import java.util.Arrays;

public final class ArraySizeHashPrinter {
    private final Object[] array;
    private final Class<?> type;

    public static ArraySizeHashPrinter of(byte[] array) {
        return new ArraySizeHashPrinter(ArraySizeHashPrinter.toObjectArray(array), byte[].class);
    }

    public static ArraySizeHashPrinter of(short[] array) {
        return new ArraySizeHashPrinter(ArraySizeHashPrinter.toObjectArray(array), short[].class);
    }

    public static ArraySizeHashPrinter of(int[] array) {
        return new ArraySizeHashPrinter(ArraySizeHashPrinter.toObjectArray(array), int[].class);
    }

    public static ArraySizeHashPrinter of(long[] array) {
        return new ArraySizeHashPrinter(ArraySizeHashPrinter.toObjectArray(array), long[].class);
    }

    public static ArraySizeHashPrinter of(float[] array) {
        return new ArraySizeHashPrinter(ArraySizeHashPrinter.toObjectArray(array), float[].class);
    }

    public static ArraySizeHashPrinter of(double[] array) {
        return new ArraySizeHashPrinter(ArraySizeHashPrinter.toObjectArray(array), double[].class);
    }

    public static ArraySizeHashPrinter of(boolean[] array) {
        return new ArraySizeHashPrinter(ArraySizeHashPrinter.toObjectArray(array), boolean[].class);
    }

    public static ArraySizeHashPrinter of(Object[] array) {
        return new ArraySizeHashPrinter(array, Object[].class);
    }

    private static Object[] toObjectArray(Object val) {
        if (val instanceof Object[]) {
            return (Object[])val;
        }
        int length = Array.getLength(val);
        Object[] outputArray = new Object[length];
        for (int i = 0; i < length; ++i) {
            outputArray[i] = Array.get(val, i);
        }
        return outputArray;
    }

    public ArraySizeHashPrinter(Object[] array, Class<?> type) {
        this.array = array;
        this.type = type;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this.type);
        if (this.array != null) {
            helper.add("length", this.array.length).add("hash", Arrays.hashCode(this.array));
        } else {
            helper.addValue((Object)this.array);
        }
        return helper.toString();
    }
}

