/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.test;

import com.google.common.collect.Lists;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.Node;
import io.atomix.cluster.discovery.BootstrapDiscoveryProvider;
import io.atomix.core.Atomix;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.core.map.AtomicMap;
import io.atomix.core.profile.Profile;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.protocols.raft.MultiRaftProtocol;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.partition.RaftPartitionGroup;
import io.atomix.protocols.raft.session.CommunicationStrategy;
import io.atomix.storage.StorageLevel;
import io.atomix.utils.net.Address;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AtomicMapPerformanceTest
implements Runnable {
    private static final int ITERATIONS = 1;
    private static final int TOTAL_OPERATIONS = 1000000;
    private static final int WRITE_RATIO = 10;
    private static final int NUM_CLIENTS = 5;
    private static final int NUM_MAPS = 50;
    private static final int KEY_LENGTH = 32;
    private static final int NUM_KEYS = 2048;
    private static final int VALUE_LENGTH = 128;
    private static final int NUM_VALUES = 2048;
    private static final String[] KEYS;
    private static final String[] VALUES;
    private static final char[] CHARS;
    private int nextId;
    private int port = 5000;
    private List<Member> members = new ArrayList<Member>();
    private List<Atomix> clients = new ArrayList<Atomix>();
    private List<Atomix> servers = new ArrayList<Atomix>();
    private final Random random = new Random();
    private final List<Long> iterations = new ArrayList<Long>();
    private final AtomicInteger totalOperations = new AtomicInteger();
    private final AtomicInteger writeCount = new AtomicInteger();
    private final AtomicInteger readCount = new AtomicInteger();
    private final Function<Member, ManagedPartitionGroup> managementGroup = member -> RaftPartitionGroup.builder((String)"system").withMembers((Collection)this.members.stream().map(m -> (String)((Object)m.id().id())).collect(Collectors.toSet())).withNumPartitions(1).withPartitionSize(this.members.size()).withDataDirectory(new File(String.format("target/perf-logs/%s/system", member.id()))).build();
    private final Function<Member, ManagedPartitionGroup> dataGroup = member -> RaftPartitionGroup.builder((String)"data").withMembers((Collection)this.members.stream().map(m -> (String)((Object)m.id().id())).collect(Collectors.toSet())).withNumPartitions(7).withPartitionSize(3).withStorageLevel(StorageLevel.DISK).withFlushOnCommit(false).withDataDirectory(new File(String.format("target/perf-logs/%s/data", member.id()))).build();
    private final Function<Member, ProxyProtocol> protocol = member -> MultiRaftProtocol.builder((String)"data").withReadConsistency(ReadConsistency.SEQUENTIAL).withCommunicationStrategy(CommunicationStrategy.LEADER).withRecoveryStrategy(Recovery.RECOVER).build();

    public static void main(String[] args) {
        new AtomicMapPerformanceTest().run();
    }

    private static String[] createStrings(int length, int count) {
        Random random = new Random(length);
        ArrayList<String> stringsList = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            stringsList.add(AtomicMapPerformanceTest.randomString(length, random));
        }
        return stringsList.toArray(new String[0]);
    }

    private static String randomString(int length, Random random) {
        char[] buffer = new char[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = CHARS[random.nextInt(CHARS.length)];
        }
        return new String(buffer);
    }

    @Override
    public void run() {
        for (int i = 0; i < 1; ++i) {
            try {
                this.iterations.add(this.runIteration());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        System.out.println("Completed 1 iterations");
        long averageRunTime = (long)this.iterations.stream().mapToLong(v -> v).average().getAsDouble();
        System.out.println(String.format("averageRunTime: %dms", averageRunTime));
        try {
            this.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long runIteration() throws Exception {
        this.reset();
        this.createServers(3);
        Atomix[] clients = new Atomix[5];
        for (int i = 0; i < 5; ++i) {
            clients[i] = this.createClient();
        }
        CompletableFuture[] futures = new CompletableFuture[50];
        AsyncAtomicMap[] maps = new AsyncAtomicMap[50];
        for (int i = 0; i < 50; ++i) {
            maps[i] = this.createMap(clients[i % clients.length]);
            futures[i] = new CompletableFuture();
        }
        long startTime = System.currentTimeMillis();
        System.out.println(String.format("Starting test to perform %d operations with %d maps", 1000000, maps.length));
        for (int i = 0; i < maps.length; ++i) {
            this.run((AsyncAtomicMap<String, String>)maps[i], futures[i]);
        }
        CompletableFuture.allOf(futures).join();
        long endTime = System.currentTimeMillis();
        long runTime = endTime - startTime;
        System.out.println(String.format("readCount: %d/%d, writeCount: %d/%d, runTime: %dms", this.readCount.get(), 1000000, this.writeCount.get(), 1000000, runTime));
        return runTime;
    }

    private void run(AsyncAtomicMap<String, String> map, CompletableFuture<Void> future) {
        int count = this.totalOperations.incrementAndGet();
        if (count > 1000000) {
            future.complete(null);
        } else if (count % 10 < 10) {
            map.put((Object)this.randomKey(), (Object)this.randomValue()).whenComplete((result, error) -> {
                if (error == null) {
                    this.writeCount.incrementAndGet();
                }
                this.run(map, future);
            });
        } else {
            map.get((Object)this.randomKey()).whenComplete((result, error) -> {
                if (error == null) {
                    this.readCount.incrementAndGet();
                }
                this.run(map, future);
            });
        }
    }

    private void reset() throws Exception {
        this.totalOperations.set(0);
        this.readCount.set(0);
        this.writeCount.set(0);
        this.shutdown();
        this.members = new ArrayList<Member>();
        this.clients = new ArrayList<Atomix>();
        this.servers = new ArrayList<Atomix>();
    }

    private void shutdown() throws Exception {
        this.clients.forEach(c -> {
            try {
                c.stop().get(1L, TimeUnit.MINUTES);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.servers.forEach(s -> {
            try {
                if (s.isRunning()) {
                    s.stop().get(1L, TimeUnit.MINUTES);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        Path directory = Paths.get("target/perf-logs/", new String[0]);
        if (Files.exists(directory, new LinkOption[0])) {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private String randomKey() {
        return KEYS[this.randomNumber(KEYS.length)];
    }

    private String randomValue() {
        return VALUES[this.randomNumber(VALUES.length)];
    }

    private int randomNumber(int limit) {
        return this.random.nextInt(limit);
    }

    private Member nextNode() {
        Address address = Address.from((String)"localhost", (int)(++this.port));
        return Member.builder((MemberId)MemberId.from((String)String.valueOf(++this.nextId))).withAddress(address).build();
    }

    private List<Atomix> createServers(int nodes) throws Exception {
        ArrayList<Atomix> servers = new ArrayList<Atomix>();
        for (int i = 0; i < nodes; ++i) {
            this.members.add(this.nextNode());
        }
        CountDownLatch latch = new CountDownLatch(nodes);
        for (int i = 0; i < nodes; ++i) {
            Atomix server = this.createServer(this.members.get(i), Lists.newArrayList(this.members));
            server.start().thenRun(() -> latch.countDown());
            servers.add(server);
        }
        latch.await(1L, TimeUnit.MINUTES);
        return servers;
    }

    private Atomix createServer(Member member, List<Node> members) {
        Atomix atomix = Atomix.builder().withMemberId(member.id()).withAddress(member.address()).withMembershipProvider(BootstrapDiscoveryProvider.builder().withNodes(members).build()).withManagementGroup(this.managementGroup.apply(member)).withPartitionGroups(new ManagedPartitionGroup[]{this.dataGroup.apply(member)}).build();
        this.servers.add(atomix);
        return atomix;
    }

    private Atomix createClient() {
        Member member = this.nextNode();
        Atomix atomix = Atomix.builder().withMemberId(member.id()).withAddress(member.address()).withMembershipProvider(BootstrapDiscoveryProvider.builder().withNodes(this.members).build()).withProfiles(new Profile[]{Profile.client()}).build();
        atomix.start().join();
        this.clients.add(atomix);
        return atomix;
    }

    private AsyncAtomicMap<String, String> createMap(Atomix atomix) {
        return ((AtomicMap)atomix.atomicMapBuilder("performance-test").withProtocol(this.protocol.apply(atomix.getMembershipService().getLocalMember())).build()).async();
    }

    static {
        CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
        KEYS = AtomicMapPerformanceTest.createStrings(32, 2048);
        VALUES = AtomicMapPerformanceTest.createStrings(128, 2048);
    }
}

