/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.protocol.SessionResponse;
import io.atomix.utils.ArraySizeHashPrinter;
import java.util.Arrays;
import java.util.Objects;

public abstract class OperationResponse
extends SessionResponse {
    protected final long index;
    protected final long eventIndex;
    protected final byte[] result;
    protected final long lastSequence;

    public OperationResponse(RaftResponse.Status status, RaftError error, long index, long eventIndex, byte[] result, long lastSequence) {
        super(status, error);
        this.index = index;
        this.eventIndex = eventIndex;
        this.result = result;
        this.lastSequence = lastSequence;
    }

    public long index() {
        return this.index;
    }

    public long eventIndex() {
        return this.eventIndex;
    }

    public byte[] result() {
        return this.result;
    }

    public long lastSequenceNumber() {
        return this.lastSequence;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status, this.index, this.eventIndex, this.lastSequence, this.result});
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().isAssignableFrom(object.getClass())) {
            return false;
        }
        OperationResponse response = (OperationResponse)object;
        return response.status == this.status && Objects.equals(response.error, this.error) && response.index == this.index && response.eventIndex == this.eventIndex && response.lastSequence == this.lastSequence && Arrays.equals(response.result, this.result);
    }

    @Override
    public String toString() {
        if (this.status == RaftResponse.Status.OK) {
            return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("index", this.index).add("eventIndex", this.eventIndex).add("result", this.result != null ? ArraySizeHashPrinter.of((byte[])this.result) : null).toString();
        }
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("error", (Object)this.error).add("lastSequence", this.lastSequence).toString();
    }

    public static abstract class Builder<T extends Builder<T, U>, U extends OperationResponse>
    extends SessionResponse.Builder<T, U> {
        protected long index;
        protected long eventIndex;
        protected byte[] result;
        protected long lastSequence;

        public T withIndex(long index) {
            Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            this.index = index;
            return (T)this;
        }

        public T withEventIndex(long eventIndex) {
            Preconditions.checkArgument((eventIndex >= 0L ? 1 : 0) != 0, (Object)"eventIndex must be positive");
            this.eventIndex = eventIndex;
            return (T)this;
        }

        public T withResult(byte[] result) {
            this.result = result;
            return (T)this;
        }

        public T withLastSequence(long lastSequence) {
            Preconditions.checkArgument((lastSequence >= 0L ? 1 : 0) != 0, (Object)"lastSequence must be positive");
            this.lastSequence = lastSequence;
            return (T)this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.status == RaftResponse.Status.OK) {
                Preconditions.checkArgument((this.index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
                Preconditions.checkArgument((this.eventIndex >= 0L ? 1 : 0) != 0, (Object)"eventIndex must be positive");
                Preconditions.checkArgument((this.lastSequence >= 0L ? 1 : 0) != 0, (Object)"lastSequence must be positive");
            }
        }
    }
}

