/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import io.atomix.cluster.NodeId;
import io.atomix.protocols.raft.protocol.LocalRaftClientProtocol;
import io.atomix.protocols.raft.protocol.LocalRaftServerProtocol;
import io.atomix.utils.serializer.Serializer;
import java.util.Map;

public abstract class LocalRaftProtocol {
    private final Serializer serializer;
    private final Map<NodeId, LocalRaftServerProtocol> servers;
    private final Map<NodeId, LocalRaftClientProtocol> clients;

    public LocalRaftProtocol(Serializer serializer, Map<NodeId, LocalRaftServerProtocol> servers, Map<NodeId, LocalRaftClientProtocol> clients) {
        this.serializer = serializer;
        this.servers = servers;
        this.clients = clients;
    }

    <T> T copy(T value) {
        return (T)this.serializer.decode(this.serializer.encode(value));
    }

    byte[] encode(Object value) {
        return this.serializer.encode(value);
    }

    <T> T decode(byte[] bytes) {
        return (T)this.serializer.decode(bytes);
    }

    LocalRaftServerProtocol server(NodeId nodeId) {
        return this.servers.get(nodeId);
    }

    LocalRaftClientProtocol client(NodeId nodeId) {
        return this.clients.get(nodeId);
    }
}

