/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import io.atomix.cluster.NodeId;
import io.atomix.messaging.Endpoint;
import io.atomix.messaging.MessagingService;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.ConfigureRequest;
import io.atomix.protocols.raft.protocol.ConfigureResponse;
import io.atomix.protocols.raft.protocol.HeartbeatRequest;
import io.atomix.protocols.raft.protocol.HeartbeatResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.JoinRequest;
import io.atomix.protocols.raft.protocol.JoinResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.LeaveRequest;
import io.atomix.protocols.raft.protocol.LeaveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.PollResponse;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftMessagingProtocol;
import io.atomix.protocols.raft.protocol.RaftServerProtocol;
import io.atomix.protocols.raft.protocol.ReconfigureRequest;
import io.atomix.protocols.raft.protocol.ReconfigureResponse;
import io.atomix.protocols.raft.protocol.ResetRequest;
import io.atomix.protocols.raft.protocol.TransferRequest;
import io.atomix.protocols.raft.protocol.TransferResponse;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public class RaftServerMessagingProtocol
extends RaftMessagingProtocol
implements RaftServerProtocol {
    public RaftServerMessagingProtocol(MessagingService messagingService, Serializer serializer, Function<NodeId, Endpoint> endpointProvider) {
        super(messagingService, serializer, endpointProvider);
    }

    @Override
    public CompletableFuture<OpenSessionResponse> openSession(NodeId nodeId, OpenSessionRequest request) {
        return this.sendAndReceive(nodeId, "open-session", request);
    }

    @Override
    public CompletableFuture<CloseSessionResponse> closeSession(NodeId nodeId, CloseSessionRequest request) {
        return this.sendAndReceive(nodeId, "close-session", request);
    }

    @Override
    public CompletableFuture<KeepAliveResponse> keepAlive(NodeId nodeId, KeepAliveRequest request) {
        return this.sendAndReceive(nodeId, "keep-alive", request);
    }

    @Override
    public CompletableFuture<QueryResponse> query(NodeId nodeId, QueryRequest request) {
        return this.sendAndReceive(nodeId, "query", request);
    }

    @Override
    public CompletableFuture<CommandResponse> command(NodeId nodeId, CommandRequest request) {
        return this.sendAndReceive(nodeId, "command", request);
    }

    @Override
    public CompletableFuture<MetadataResponse> metadata(NodeId nodeId, MetadataRequest request) {
        return this.sendAndReceive(nodeId, "metadata", request);
    }

    @Override
    public CompletableFuture<JoinResponse> join(NodeId nodeId, JoinRequest request) {
        return this.sendAndReceive(nodeId, "join", request);
    }

    @Override
    public CompletableFuture<LeaveResponse> leave(NodeId nodeId, LeaveRequest request) {
        return this.sendAndReceive(nodeId, "leave", request);
    }

    @Override
    public CompletableFuture<ConfigureResponse> configure(NodeId nodeId, ConfigureRequest request) {
        return this.sendAndReceive(nodeId, "configure", request);
    }

    @Override
    public CompletableFuture<ReconfigureResponse> reconfigure(NodeId nodeId, ReconfigureRequest request) {
        return this.sendAndReceive(nodeId, "reconfigure", request);
    }

    @Override
    public CompletableFuture<InstallResponse> install(NodeId nodeId, InstallRequest request) {
        return this.sendAndReceive(nodeId, "install", request);
    }

    @Override
    public CompletableFuture<TransferResponse> transfer(NodeId nodeId, TransferRequest request) {
        return this.sendAndReceive(nodeId, "transfer", request);
    }

    @Override
    public CompletableFuture<PollResponse> poll(NodeId nodeId, PollRequest request) {
        return this.sendAndReceive(nodeId, "poll", request);
    }

    @Override
    public CompletableFuture<VoteResponse> vote(NodeId nodeId, VoteRequest request) {
        return this.sendAndReceive(nodeId, "vote", request);
    }

    @Override
    public CompletableFuture<AppendResponse> append(NodeId nodeId, AppendRequest request) {
        return this.sendAndReceive(nodeId, "append", request);
    }

    @Override
    public void publish(NodeId nodeId, PublishRequest request) {
        this.sendAsync(nodeId, String.format("publish-%d", request.session()), request);
    }

    @Override
    public CompletableFuture<HeartbeatResponse> heartbeat(NodeId nodeId, HeartbeatRequest request) {
        return this.sendAndReceive(nodeId, "heartbeat", request);
    }

    @Override
    public void registerOpenSessionHandler(Function<OpenSessionRequest, CompletableFuture<OpenSessionResponse>> handler) {
        this.registerHandler("open-session", handler);
    }

    @Override
    public void unregisterOpenSessionHandler() {
        this.unregisterHandler("open-session");
    }

    @Override
    public void registerCloseSessionHandler(Function<CloseSessionRequest, CompletableFuture<CloseSessionResponse>> handler) {
        this.registerHandler("close-session", handler);
    }

    @Override
    public void unregisterCloseSessionHandler() {
        this.unregisterHandler("close-session");
    }

    @Override
    public void registerKeepAliveHandler(Function<KeepAliveRequest, CompletableFuture<KeepAliveResponse>> handler) {
        this.registerHandler("keep-alive", handler);
    }

    @Override
    public void unregisterKeepAliveHandler() {
        this.unregisterHandler("keep-alive");
    }

    @Override
    public void registerQueryHandler(Function<QueryRequest, CompletableFuture<QueryResponse>> handler) {
        this.registerHandler("query", handler);
    }

    @Override
    public void unregisterQueryHandler() {
        this.unregisterHandler("query");
    }

    @Override
    public void registerCommandHandler(Function<CommandRequest, CompletableFuture<CommandResponse>> handler) {
        this.registerHandler("command", handler);
    }

    @Override
    public void unregisterCommandHandler() {
        this.unregisterHandler("command");
    }

    @Override
    public void registerMetadataHandler(Function<MetadataRequest, CompletableFuture<MetadataResponse>> handler) {
        this.registerHandler("metadata", handler);
    }

    @Override
    public void unregisterMetadataHandler() {
        this.unregisterHandler("metadata");
    }

    @Override
    public void registerJoinHandler(Function<JoinRequest, CompletableFuture<JoinResponse>> handler) {
        this.registerHandler("join", handler);
    }

    @Override
    public void unregisterJoinHandler() {
        this.unregisterHandler("join");
    }

    @Override
    public void registerLeaveHandler(Function<LeaveRequest, CompletableFuture<LeaveResponse>> handler) {
        this.registerHandler("leave", handler);
    }

    @Override
    public void unregisterLeaveHandler() {
        this.unregisterHandler("leave");
    }

    @Override
    public void registerConfigureHandler(Function<ConfigureRequest, CompletableFuture<ConfigureResponse>> handler) {
        this.registerHandler("configure", handler);
    }

    @Override
    public void unregisterConfigureHandler() {
        this.unregisterHandler("configure");
    }

    @Override
    public void registerReconfigureHandler(Function<ReconfigureRequest, CompletableFuture<ReconfigureResponse>> handler) {
        this.registerHandler("reconfigure", handler);
    }

    @Override
    public void unregisterReconfigureHandler() {
        this.unregisterHandler("reconfigure");
    }

    @Override
    public void registerInstallHandler(Function<InstallRequest, CompletableFuture<InstallResponse>> handler) {
        this.registerHandler("install", handler);
    }

    @Override
    public void unregisterInstallHandler() {
        this.unregisterHandler("install");
    }

    @Override
    public void registerTransferHandler(Function<TransferRequest, CompletableFuture<TransferResponse>> handler) {
        this.registerHandler("transfer", handler);
    }

    @Override
    public void unregisterTransferHandler() {
        this.unregisterHandler("transfer");
    }

    @Override
    public void registerPollHandler(Function<PollRequest, CompletableFuture<PollResponse>> handler) {
        this.registerHandler("poll", handler);
    }

    @Override
    public void unregisterPollHandler() {
        this.unregisterHandler("poll");
    }

    @Override
    public void registerVoteHandler(Function<VoteRequest, CompletableFuture<VoteResponse>> handler) {
        this.registerHandler("vote", handler);
    }

    @Override
    public void unregisterVoteHandler() {
        this.unregisterHandler("vote");
    }

    @Override
    public void registerAppendHandler(Function<AppendRequest, CompletableFuture<AppendResponse>> handler) {
        this.registerHandler("append", handler);
    }

    @Override
    public void unregisterAppendHandler() {
        this.unregisterHandler("append");
    }

    @Override
    public void registerResetListener(SessionId sessionId, Consumer<ResetRequest> listener, Executor executor) {
        this.messagingService.registerHandler(String.format("reset-%d", sessionId.id()), (e, p) -> listener.accept((ResetRequest)this.serializer.decode(p)), executor);
    }

    @Override
    public void unregisterResetListener(SessionId sessionId) {
        this.messagingService.unregisterHandler(String.format("reset-%d", sessionId.id()));
    }
}

