/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.protocols.raft.protocol.ConfigurationRequest;
import java.util.Objects;

public class ReconfigureRequest
extends ConfigurationRequest {
    private final long index;
    private final long term;

    public static Builder newBuilder() {
        return new Builder();
    }

    public ReconfigureRequest(RaftMember member, long index, long term) {
        super(member);
        this.index = index;
        this.term = term;
    }

    public long index() {
        return this.index;
    }

    public long term() {
        return this.term;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.index, this.member);
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ReconfigureRequest) {
            ReconfigureRequest request = (ReconfigureRequest)object;
            return request.index == this.index && request.term == this.term && request.member.equals(this.member);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("index", this.index).add("term", this.term).add("member", (Object)this.member).toString();
    }

    public static class Builder
    extends ConfigurationRequest.Builder<Builder, ReconfigureRequest> {
        private long index = -1L;
        private long term = -1L;

        public Builder withIndex(long index) {
            Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            this.index = index;
            return this;
        }

        public Builder withTerm(long term) {
            Preconditions.checkArgument((term >= 0L ? 1 : 0) != 0, (Object)"term must be positive");
            this.term = term;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkArgument((this.index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            Preconditions.checkArgument((this.term >= 0L ? 1 : 0) != 0, (Object)"term must be positive");
        }

        public ReconfigureRequest build() {
            this.validate();
            return new ReconfigureRequest(this.member, this.index, this.term);
        }
    }
}

