/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.ThreadModel;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.cluster.RaftCluster;
import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.protocols.raft.impl.DefaultRaftServer;
import io.atomix.protocols.raft.impl.RaftServiceFactoryRegistry;
import io.atomix.protocols.raft.protocol.RaftServerProtocol;
import io.atomix.protocols.raft.service.RaftService;
import io.atomix.protocols.raft.storage.RaftStorage;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface RaftServer {
    public static Builder newBuilder() {
        return RaftServer.newBuilder(null);
    }

    public static Builder newBuilder(MemberId localMemberId) {
        return new DefaultRaftServer.Builder(localMemberId);
    }

    public String name();

    public RaftCluster cluster();

    public Role getRole();

    default public boolean isLeader() {
        return this.getRole() == Role.LEADER;
    }

    default public boolean isFollower() {
        return this.getRole() == Role.FOLLOWER;
    }

    public void addRoleChangeListener(Consumer<Role> var1);

    public void removeRoleChangeListener(Consumer<Role> var1);

    default public CompletableFuture<RaftServer> bootstrap() {
        return this.bootstrap(Collections.emptyList());
    }

    default public CompletableFuture<RaftServer> bootstrap(MemberId ... members) {
        return this.bootstrap(Arrays.asList(members));
    }

    public CompletableFuture<RaftServer> bootstrap(Collection<MemberId> var1);

    default public CompletableFuture<RaftServer> join(MemberId ... members) {
        return this.join(Arrays.asList(members));
    }

    public CompletableFuture<RaftServer> join(Collection<MemberId> var1);

    default public CompletableFuture<RaftServer> listen(MemberId ... cluster) {
        return this.listen(Arrays.asList((Object[])Preconditions.checkNotNull((Object)cluster)));
    }

    public CompletableFuture<RaftServer> listen(Collection<MemberId> var1);

    public CompletableFuture<RaftServer> promote();

    public boolean isRunning();

    public CompletableFuture<Void> shutdown();

    public CompletableFuture<Void> leave();

    public static abstract class Builder
    implements io.atomix.utils.Builder<RaftServer> {
        private static final Duration DEFAULT_ELECTION_TIMEOUT = Duration.ofMillis(750L);
        private static final Duration DEFAULT_HEARTBEAT_INTERVAL = Duration.ofMillis(250L);
        private static final int DEFAULT_ELECTION_THRESHOLD = 3;
        private static final Duration DEFAULT_SESSION_TIMEOUT = Duration.ofMillis(5000L);
        private static final int DEFAULT_SESSION_FAILURE_THRESHOLD = 3;
        private static final ThreadModel DEFAULT_THREAD_MODEL = ThreadModel.SHARED_THREAD_POOL;
        private static final int DEFAULT_THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
        protected String name;
        protected MemberId localMemberId;
        protected RaftServerProtocol protocol;
        protected RaftStorage storage;
        protected Duration electionTimeout = DEFAULT_ELECTION_TIMEOUT;
        protected Duration heartbeatInterval = DEFAULT_HEARTBEAT_INTERVAL;
        protected int electionThreshold = 3;
        protected Duration sessionTimeout = DEFAULT_SESSION_TIMEOUT;
        protected int sessionFailureThreshold = 3;
        protected final RaftServiceFactoryRegistry serviceRegistry = new RaftServiceFactoryRegistry();
        protected ThreadModel threadModel = DEFAULT_THREAD_MODEL;
        protected int threadPoolSize = DEFAULT_THREAD_POOL_SIZE;

        protected Builder(MemberId localMemberId) {
            this.localMemberId = (MemberId)Preconditions.checkNotNull((Object)localMemberId, (Object)"localMemberId cannot be null");
        }

        public Builder withName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
            return this;
        }

        @Deprecated
        public Builder withType(RaftMember.Type type) {
            return this;
        }

        public Builder withProtocol(RaftServerProtocol protocol) {
            this.protocol = (RaftServerProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
            return this;
        }

        public Builder withThreadModel(ThreadModel threadModel) {
            this.threadModel = (ThreadModel)((Object)Preconditions.checkNotNull((Object)((Object)threadModel), (Object)"threadModel cannot be null"));
            return this;
        }

        public Builder withStorage(RaftStorage storage) {
            this.storage = (RaftStorage)Preconditions.checkNotNull((Object)storage, (Object)"storage cannot be null");
            return this;
        }

        public Builder addService(String type, Supplier<RaftService> factory) {
            this.serviceRegistry.register(type, factory);
            return this;
        }

        public Builder withElectionTimeout(Duration electionTimeout) {
            Preconditions.checkNotNull((Object)electionTimeout, (Object)"electionTimeout cannot be null");
            Preconditions.checkArgument((!electionTimeout.isNegative() && !electionTimeout.isZero() ? 1 : 0) != 0, (Object)"electionTimeout must be positive");
            Preconditions.checkArgument((electionTimeout.toMillis() > this.heartbeatInterval.toMillis() ? 1 : 0) != 0, (Object)"electionTimeout must be greater than heartbeatInterval");
            this.electionTimeout = electionTimeout;
            return this;
        }

        public Builder withHeartbeatInterval(Duration heartbeatInterval) {
            Preconditions.checkNotNull((Object)heartbeatInterval, (Object)"heartbeatInterval cannot be null");
            Preconditions.checkArgument((!heartbeatInterval.isNegative() && !heartbeatInterval.isZero() ? 1 : 0) != 0, (Object)"sessionTimeout must be positive");
            Preconditions.checkArgument((heartbeatInterval.toMillis() < this.electionTimeout.toMillis() ? 1 : 0) != 0, (Object)"heartbeatInterval must be less than electionTimeout");
            this.heartbeatInterval = heartbeatInterval;
            return this;
        }

        public Builder withElectionThreshold(int electionThreshold) {
            Preconditions.checkArgument((electionThreshold > 0 ? 1 : 0) != 0, (Object)"electionThreshold must be positive");
            this.electionThreshold = electionThreshold;
            return this;
        }

        public Builder withSessionTimeout(Duration sessionTimeout) {
            Preconditions.checkNotNull((Object)sessionTimeout, (Object)"sessionTimeout cannot be null");
            Preconditions.checkArgument((!sessionTimeout.isNegative() && !sessionTimeout.isZero() ? 1 : 0) != 0, (Object)"sessionTimeout must be positive");
            Preconditions.checkArgument((sessionTimeout.toMillis() > this.electionTimeout.toMillis() ? 1 : 0) != 0, (Object)"sessionTimeout must be greater than electionTimeout");
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        public Builder withSessionFailureThreshold(int sessionFailureThreshold) {
            Preconditions.checkArgument((sessionFailureThreshold > 0 ? 1 : 0) != 0, (Object)"sessionFailureThreshold must be positive");
            this.sessionFailureThreshold = sessionFailureThreshold;
            return this;
        }

        public Builder withThreadPoolSize(int threadPoolSize) {
            Preconditions.checkArgument((threadPoolSize > 0 ? 1 : 0) != 0, (Object)"threadPoolSize must be positive");
            this.threadPoolSize = threadPoolSize;
            return this;
        }
    }

    public static enum Role {
        INACTIVE(false),
        PASSIVE(false),
        PROMOTABLE(false),
        FOLLOWER(true),
        CANDIDATE(true),
        LEADER(true);

        private final boolean active;

        private Role(boolean active) {
            this.active = active;
        }

        public boolean active() {
            return this.active;
        }
    }
}

