/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.protocol.LocalRaftClientProtocol;
import io.atomix.protocols.raft.protocol.LocalRaftServerProtocol;
import io.atomix.serializer.Serializer;
import java.util.Map;

public abstract class LocalRaftProtocol {
    private final Serializer serializer;
    private final Map<MemberId, LocalRaftServerProtocol> servers;
    private final Map<MemberId, LocalRaftClientProtocol> clients;

    public LocalRaftProtocol(Serializer serializer, Map<MemberId, LocalRaftServerProtocol> servers, Map<MemberId, LocalRaftClientProtocol> clients) {
        this.serializer = serializer;
        this.servers = servers;
        this.clients = clients;
    }

    <T> T copy(T value) {
        return (T)this.serializer.decode(this.serializer.encode(value));
    }

    byte[] encode(Object value) {
        return this.serializer.encode(value);
    }

    <T> T decode(byte[] bytes) {
        return (T)this.serializer.decode(bytes);
    }

    LocalRaftServerProtocol server(MemberId memberId) {
        return this.servers.get(memberId);
    }

    LocalRaftClientProtocol client(MemberId memberId) {
        return this.clients.get(memberId);
    }
}

