/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import io.atomix.core.semaphore.AsyncAtomicSemaphore;
import io.atomix.core.semaphore.AtomicSemaphoreConfig;
import io.atomix.core.semaphore.AtomicSemaphoreType;
import io.atomix.primitive.PrimitiveType;
import io.atomix.rest.AtomixResource;
import io.atomix.rest.resources.PrimitiveResource;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtomixResource
@Path(value="/atomic-semaphore")
public class AtomicSemaphoreResource
extends PrimitiveResource<AsyncAtomicSemaphore, AtomicSemaphoreConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomicSemaphoreResource.class);

    public AtomicSemaphoreResource() {
        super((PrimitiveType)AtomicSemaphoreType.instance());
    }

    @POST
    @Path(value="/{name}/acquire")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void acquire(@PathParam(value="name") String name, Integer permits, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(semaphore -> semaphore.acquire(permits != null ? permits : 1))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result.value()).build());
            } else {
                LOGGER.warn("An error occurred", error);
                response.resume((Object)Response.serverError());
            }
        });
    }

    @POST
    @Path(value="/{name}/release")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void release(@PathParam(value="name") String name, Integer permits, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(semaphore -> semaphore.release(permits != null ? permits : 1))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("An error occurred", error);
                response.resume((Object)Response.serverError());
            }
        });
    }

    @POST
    @Path(value="/{name}/increase")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void increase(@PathParam(value="name") String name, Integer permits, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(semaphore -> semaphore.increasePermits(permits != null ? permits : 1))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("An error occurred", error);
                response.resume((Object)Response.serverError());
            }
        });
    }

    @POST
    @Path(value="/{name}/reduce")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public void reduce(@PathParam(value="name") String name, Integer permits, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(semaphore -> semaphore.reducePermits(permits != null ? permits : 1))).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("An error occurred", error);
                response.resume((Object)Response.serverError());
            }
        });
    }

    @GET
    @Path(value="/{name}/permits")
    @Produces(value={"application/json"})
    public void availablePermits(@PathParam(value="name") String name, @Suspended AsyncResponse response) {
        ((CompletableFuture)this.getPrimitive(name).thenCompose(semaphore -> semaphore.availablePermits())).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result).build());
            } else {
                LOGGER.warn("An error occurred", error);
                response.resume((Object)Response.serverError());
            }
        });
    }
}

