/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.cluster.messaging.ClusterEventingService;
import io.atomix.cluster.messaging.Subscription;
import io.atomix.rest.utils.EventLog;
import io.atomix.rest.utils.EventManager;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/events")
public class EventsResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventsResource.class);
    private static final int UUID_STRING_LENGTH = UUID.randomUUID().toString().length();

    private String getEventLogName(String subject, String id) {
        return String.format("%s-%s", subject, id);
    }

    @POST
    @Path(value="/{subject}")
    @Consumes(value={"text/plain"})
    public Response publish(@PathParam(value="subject") String subject, @Context ClusterEventingService eventService, String body) {
        eventService.broadcast(subject, (Object)body);
        return Response.ok().build();
    }

    @GET
    @Path(value="/{subject}")
    @Produces(value={"text/plain"})
    public void next(@PathParam(value="subject") String subject, @Context ClusterEventingService eventService, @Context EventManager events, @Suspended AsyncResponse response) {
        EventLog eventLog = events.getOrCreateEventLog(ClusterEventingService.class, subject, l -> e -> l.addEvent(e));
        CompletableFuture openFuture = eventLog.open() ? eventService.subscribe(subject, eventLog.listener(), MoreExecutors.directExecutor()) : CompletableFuture.completedFuture(null);
        openFuture.whenComplete((result, error) -> {
            if (error == null) {
                eventLog.nextEvent().whenComplete((event, eventError) -> {
                    if (eventError == null) {
                        response.resume((Object)Response.ok((Object)event).build());
                    } else {
                        response.resume((Object)Response.noContent().build());
                    }
                });
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    @Path(value="/{subject}")
    public void delete(@PathParam(value="subject") String subject, @Context ClusterEventingService eventService, @Context EventManager events, @Suspended AsyncResponse response) {
        List subscriptions;
        EventLog eventLog = events.removeEventLog(ClusterEventingService.class, subject);
        if (eventLog != null && eventLog.close() && (subscriptions = eventService.getSubscriptions(subject)) != null && !subscriptions.isEmpty()) {
            ((Subscription)subscriptions.get(0)).close().whenComplete((result, error) -> response.resume((Object)Response.ok().build()));
        }
    }

    @GET
    @Path(value="/{subject}/subscribers")
    @Produces(value={"application/json"})
    public Response getSubscribers(@PathParam(value="subject") String subject, @Context EventManager events) {
        return Response.ok(events.getEventLogNames(ClusterEventingService.class).stream().filter(name -> name.length() == subject.length() + 1 + UUID_STRING_LENGTH && name.substring(0, name.length() - UUID_STRING_LENGTH - 1).equals(subject)).map(name -> name.substring(subject.length() + 1)).collect(Collectors.toList())).build();
    }

    @POST
    @Path(value="/{subject}/subscribers")
    @Produces(value={"text/plain"})
    public void subscribe(@PathParam(value="subject") String subject, @Context ClusterEventingService eventService, @Context EventManager events, @Suspended AsyncResponse response) {
        String id = UUID.randomUUID().toString();
        EventLog eventLog = events.getOrCreateEventLog(ClusterEventingService.class, this.getEventLogName(subject, id), l -> e -> l.addEvent(e));
        eventService.subscribe(subject, eventLog.listener(), MoreExecutors.directExecutor()).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)id).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/{subject}/subscribers/{id}")
    @Produces(value={"text/plain"})
    public void nextSession(@PathParam(value="subject") String subject, @PathParam(value="id") String id, @Context EventManager events, @Suspended AsyncResponse response) {
        EventLog eventLog = events.getEventLog(ClusterEventingService.class, this.getEventLogName(subject, id));
        if (eventLog == null) {
            LOGGER.warn("Unknown subscriber {}", (Object)id);
            response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            return;
        }
        eventLog.nextEvent().whenComplete((event, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)event).build());
            } else {
                LOGGER.warn("Subscriber {} closed", (Object)id);
                response.resume((Object)Response.noContent().build());
            }
        });
    }

    @DELETE
    @Path(value="/{subject}/subscribers/{id}")
    public void unsubscribe(@PathParam(value="subject") String subject, @PathParam(value="id") String id, @Context ClusterEventingService eventService, @Context EventManager events, @Suspended AsyncResponse response) {
        List subscriptions;
        EventLog eventLog = events.getEventLog(ClusterEventingService.class, this.getEventLogName(subject, id));
        if (eventLog != null && eventLog.close() && (subscriptions = eventService.getSubscriptions(subject)) != null && !subscriptions.isEmpty()) {
            ((Subscription)subscriptions.get(0)).close().whenComplete((result, error) -> response.resume((Object)Response.ok().build()));
        }
    }
}

