/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.Member;
import io.atomix.primitive.partition.MemberGroup;
import io.atomix.primitive.partition.MemberGroupId;
import java.util.Objects;
import java.util.Set;

public class NodeMemberGroup
implements MemberGroup {
    private final MemberGroupId groupId;
    private final Set<Member> members;

    public NodeMemberGroup(MemberGroupId groupId, Set<Member> members) {
        this.groupId = (MemberGroupId)((Object)Preconditions.checkNotNull((Object)((Object)groupId)));
        this.members = (Set)Preconditions.checkNotNull(members);
    }

    @Override
    public MemberGroupId id() {
        return this.groupId;
    }

    @Override
    public boolean isMember(Member member) {
        return this.members.contains(member);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.groupId, this.members});
    }

    public boolean equals(Object object) {
        if (object instanceof NodeMemberGroup) {
            NodeMemberGroup memberGroup = (NodeMemberGroup)object;
            return memberGroup.groupId.equals((Object)this.groupId) && memberGroup.members.equals(this.members);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.groupId).add("nodes", this.members).toString();
    }
}

