/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.DistributedPrimitive;
import io.atomix.primitive.PrimitiveType;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public abstract class DelegatingDistributedPrimitive
implements AsyncPrimitive {
    private final AsyncPrimitive primitive;

    public DelegatingDistributedPrimitive(AsyncPrimitive primitive) {
        this.primitive = (AsyncPrimitive)Preconditions.checkNotNull((Object)primitive);
    }

    @Override
    public String name() {
        return this.primitive.name();
    }

    @Override
    public PrimitiveType primitiveType() {
        return this.primitive.primitiveType();
    }

    @Override
    public CompletableFuture<Void> destroy() {
        return this.primitive.destroy();
    }

    @Override
    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.primitive.addStatusChangeListener(listener);
    }

    @Override
    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.primitive.removeStatusChangeListener(listener);
    }

    @Override
    public Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners() {
        return this.primitive.statusChangeListeners();
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.primitive.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("delegate", (Object)this.primitive).toString();
    }

    public int hashCode() {
        return Objects.hash(this.primitive);
    }

    public boolean equals(Object other) {
        return other instanceof DelegatingDistributedPrimitive && this.primitive.equals(((DelegatingDistributedPrimitive)other).primitive);
    }
}

