/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup.roles;

import io.atomix.cluster.NodeId;
import io.atomix.primitive.service.Commit;
import io.atomix.primitive.service.impl.DefaultCommit;
import io.atomix.protocols.backup.PrimaryBackupServer;
import io.atomix.protocols.backup.impl.PrimaryBackupSession;
import io.atomix.protocols.backup.protocol.BackupOperation;
import io.atomix.protocols.backup.protocol.BackupRequest;
import io.atomix.protocols.backup.protocol.BackupResponse;
import io.atomix.protocols.backup.protocol.CloseOperation;
import io.atomix.protocols.backup.protocol.ExecuteOperation;
import io.atomix.protocols.backup.protocol.ExpireOperation;
import io.atomix.protocols.backup.protocol.HeartbeatOperation;
import io.atomix.protocols.backup.protocol.RestoreRequest;
import io.atomix.protocols.backup.roles.PrimaryBackupRole;
import io.atomix.protocols.backup.service.impl.PrimaryBackupServiceContext;
import io.atomix.storage.buffer.BufferInput;
import io.atomix.storage.buffer.HeapBuffer;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class BackupRole
extends PrimaryBackupRole {
    private final Queue<BackupOperation> operations = new LinkedList<BackupOperation>();

    public BackupRole(PrimaryBackupServiceContext service) {
        super(PrimaryBackupServer.Role.BACKUP, service);
    }

    @Override
    public CompletableFuture<BackupResponse> backup(BackupRequest request) {
        this.logRequest(request);
        if (request.term() > this.context.currentTerm()) {
            this.context.resetTerm(request.term(), request.primary());
        } else if (request.term() < this.context.currentTerm()) {
            return CompletableFuture.completedFuture(BackupResponse.error());
        }
        this.operations.addAll(request.operations());
        long currentCommitIndex = this.context.getCommitIndex();
        long nextCommitIndex = this.context.setCommitIndex(request.index());
        this.context.threadContext().execute(() -> this.applyOperations(currentCommitIndex, nextCommitIndex));
        return CompletableFuture.completedFuture(this.logResponse(BackupResponse.ok()));
    }

    private void applyOperations(long fromIndex, long toIndex) {
        for (long i = fromIndex + 1L; i <= toIndex; ++i) {
            BackupOperation operation = this.operations.poll();
            if (operation == null) {
                this.requestRestore(this.context.primary());
                break;
            }
            if (this.context.nextIndex(operation.index())) {
                switch (operation.type()) {
                    case EXECUTE: {
                        this.applyExecute((ExecuteOperation)operation);
                        break;
                    }
                    case HEARTBEAT: {
                        this.applyHeartbeat((HeartbeatOperation)operation);
                        break;
                    }
                    case EXPIRE: {
                        this.applyExpire((ExpireOperation)operation);
                        break;
                    }
                    case CLOSE: {
                        this.applyClose((CloseOperation)operation);
                    }
                }
                continue;
            }
            this.requestRestore(this.context.primary());
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyExecute(ExecuteOperation operation) {
        PrimaryBackupSession session = this.context.getOrCreateSession(operation.session(), operation.node());
        if (operation.operation() != null) {
            try {
                this.context.service().apply((Commit)new DefaultCommit(this.context.setIndex(operation.index()), operation.operation().id(), (Object)operation.operation().value(), this.context.setSession(session), this.context.setTimestamp(operation.timestamp())));
            }
            catch (Exception e) {
                this.log.warn("Failed to apply operation: {}", (Throwable)e);
            }
            finally {
                this.context.setSession(null);
            }
        }
    }

    private void applyHeartbeat(HeartbeatOperation operation) {
        this.context.setTimestamp(operation.timestamp());
    }

    private void applyExpire(ExpireOperation operation) {
        this.context.setTimestamp(operation.timestamp());
        PrimaryBackupSession session = this.context.getSession(operation.session());
        if (session != null) {
            this.context.sessions().expireSession(session);
        }
    }

    private void applyClose(CloseOperation operation) {
        this.context.setTimestamp(operation.timestamp());
        PrimaryBackupSession session = this.context.getSession(operation.session());
        if (session != null) {
            this.context.sessions().closeSession(session);
        }
    }

    private void requestRestore(NodeId primary) {
        this.context.protocol().restore(primary, RestoreRequest.request(this.context.descriptor(), this.context.currentTerm())).whenCompleteAsync((response, error) -> {
            if (error == null) {
                this.context.resetIndex(response.index(), response.timestamp());
                this.context.service().restore((BufferInput)HeapBuffer.wrap((byte[])response.data()));
                this.operations.clear();
            }
        }, (Executor)this.context.threadContext());
    }
}

