/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.log.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.log.LogClient;
import io.atomix.primitive.log.LogSession;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.Partitioner;
import io.atomix.primitive.protocol.LogProtocol;
import io.atomix.utils.concurrent.Futures;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class DistributedLogClient
implements LogClient {
    private final LogProtocol protocol;
    private final List<PartitionId> partitionIds = new CopyOnWriteArrayList<PartitionId>();
    private final Map<PartitionId, LogSession> partitions = Maps.newConcurrentMap();
    private final List<LogSession> sortedPartitions = new CopyOnWriteArrayList<LogSession>();
    private final Partitioner<String> partitioner;
    private final Set<Consumer<PrimitiveState>> stateChangeListeners = Sets.newCopyOnWriteArraySet();
    private final Map<PartitionId, PrimitiveState> states = Maps.newHashMap();
    private volatile PrimitiveState state = PrimitiveState.CLOSED;

    public DistributedLogClient(LogProtocol protocol, Collection<LogSession> partitions, Partitioner<String> partitioner) {
        this.protocol = (LogProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
        this.partitioner = (Partitioner)Preconditions.checkNotNull(partitioner, (Object)"partitioner cannot be null");
        partitions.forEach(partition -> {
            this.partitionIds.add(partition.partitionId());
            this.partitions.put(partition.partitionId(), (LogSession)partition);
            this.sortedPartitions.add((LogSession)partition);
            this.states.put(partition.partitionId(), PrimitiveState.CLOSED);
            partition.addStateChangeListener(state -> this.onStateChange(partition.partitionId(), (PrimitiveState)state));
        });
    }

    public LogProtocol protocol() {
        return this.protocol;
    }

    public PrimitiveState state() {
        return this.state;
    }

    public Collection<LogSession> getPartitions() {
        return this.sortedPartitions;
    }

    public Collection<PartitionId> getPartitionIds() {
        return this.partitions.keySet();
    }

    public LogSession getPartition(PartitionId partitionId) {
        return this.partitions.get(partitionId);
    }

    public PartitionId getPartitionId(String key) {
        return this.partitioner.partition((Object)key, this.partitionIds);
    }

    public void addStateChangeListener(Consumer<PrimitiveState> listener) {
        this.stateChangeListeners.add(listener);
    }

    public void removeStateChangeListener(Consumer<PrimitiveState> listener) {
        this.stateChangeListeners.remove(listener);
    }

    private synchronized void onStateChange(PartitionId partitionId, PrimitiveState state) {
        this.states.put(partitionId, state);
        switch (state) {
            case CONNECTED: {
                if (this.states.containsValue(PrimitiveState.SUSPENDED) || this.states.containsValue(PrimitiveState.CLOSED)) break;
                this.changeState(PrimitiveState.CONNECTED);
                break;
            }
            case SUSPENDED: {
                this.changeState(PrimitiveState.SUSPENDED);
                break;
            }
            case CLOSED: {
                this.changeState(PrimitiveState.CLOSED);
            }
        }
    }

    private synchronized void changeState(PrimitiveState state) {
        if (this.state != state) {
            this.state = state;
            this.stateChangeListeners.forEach(l -> l.accept(state));
        }
    }

    public CompletableFuture<LogClient> connect() {
        return Futures.allOf(this.partitions.values().stream().map(LogSession::connect)).thenApply(v -> {
            this.changeState(PrimitiveState.CONNECTED);
            return this;
        });
    }

    public CompletableFuture<Void> close() {
        return Futures.allOf(this.partitions.values().stream().map(LogSession::connect)).thenRun(() -> this.changeState(PrimitiveState.CLOSED));
    }
}

