/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.messaging.impl.AbstractMessageDecoder;
import io.atomix.cluster.messaging.impl.ProtocolMessage;
import io.atomix.cluster.messaging.impl.ProtocolReply;
import io.atomix.cluster.messaging.impl.ProtocolRequest;
import io.atomix.utils.net.Address;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;

class MessageDecoderV2
extends AbstractMessageDecoder {
    private DecoderState currentState = DecoderState.READ_SENDER_HOST_LENGTH;
    private int senderHostLength;
    private String senderHost;
    private int senderPort;
    private Address senderAddress;
    private ProtocolMessage.Type type;
    private long messageId;
    private int contentLength;
    private byte[] content;
    private int subjectLength;

    MessageDecoderV2() {
    }

    protected void decode(ChannelHandlerContext context, ByteBuf buffer, List<Object> out) throws Exception {
        block2 : switch (this.currentState) {
            case READ_SENDER_HOST_LENGTH: {
                if (buffer.readableBytes() < 2) {
                    return;
                }
                this.senderHostLength = buffer.readShort();
                this.currentState = DecoderState.READ_SENDER_HOST;
            }
            case READ_SENDER_HOST: {
                if (buffer.readableBytes() < this.senderHostLength) {
                    return;
                }
                this.senderHost = MessageDecoderV2.readString(buffer, this.senderHostLength);
                this.currentState = DecoderState.READ_SENDER_PORT;
            }
            case READ_SENDER_PORT: {
                if (buffer.readableBytes() < 4) {
                    return;
                }
                this.senderPort = buffer.readInt();
                this.senderAddress = Address.from((String)this.senderHost, (int)this.senderPort);
                this.currentState = DecoderState.READ_TYPE;
            }
            case READ_TYPE: {
                if (buffer.readableBytes() < 1) {
                    return;
                }
                this.type = ProtocolMessage.Type.forId(buffer.readByte());
                this.currentState = DecoderState.READ_MESSAGE_ID;
            }
            case READ_MESSAGE_ID: {
                try {
                    this.messageId = MessageDecoderV2.readLong(buffer);
                }
                catch (AbstractMessageDecoder.Escape e) {
                    return;
                }
                this.currentState = DecoderState.READ_CONTENT_LENGTH;
            }
            case READ_CONTENT_LENGTH: {
                try {
                    this.contentLength = MessageDecoderV2.readInt(buffer);
                }
                catch (AbstractMessageDecoder.Escape e) {
                    return;
                }
                this.currentState = DecoderState.READ_CONTENT;
            }
            case READ_CONTENT: {
                if (buffer.readableBytes() < this.contentLength) {
                    return;
                }
                if (this.contentLength > 0) {
                    this.content = new byte[this.contentLength];
                    buffer.readBytes(this.content);
                } else {
                    this.content = EMPTY_PAYLOAD;
                }
                switch (this.type) {
                    case REQUEST: {
                        this.currentState = DecoderState.READ_SUBJECT_LENGTH;
                        break block2;
                    }
                    case REPLY: {
                        this.currentState = DecoderState.READ_STATUS;
                        break block2;
                    }
                }
                Preconditions.checkState((boolean)false, (Object)"Must not be here");
                break;
            }
        }
        block15 : switch (this.type) {
            case REQUEST: {
                switch (this.currentState) {
                    case READ_SUBJECT_LENGTH: {
                        if (buffer.readableBytes() < 2) {
                            return;
                        }
                        this.subjectLength = buffer.readShort();
                        this.currentState = DecoderState.READ_SUBJECT;
                    }
                    case READ_SUBJECT: {
                        if (buffer.readableBytes() < this.subjectLength) {
                            return;
                        }
                        String subject = MessageDecoderV2.readString(buffer, this.subjectLength);
                        ProtocolRequest message = new ProtocolRequest(this.messageId, this.senderAddress, subject, this.content);
                        out.add(message);
                        this.currentState = DecoderState.READ_TYPE;
                        break block15;
                    }
                }
                break;
            }
            case REPLY: {
                switch (this.currentState) {
                    case READ_STATUS: {
                        if (buffer.readableBytes() < 1) {
                            return;
                        }
                        ProtocolReply.Status status = ProtocolReply.Status.forId(buffer.readByte());
                        ProtocolReply message = new ProtocolReply(this.messageId, this.content, status);
                        out.add(message);
                        this.currentState = DecoderState.READ_TYPE;
                        break block15;
                    }
                }
                break;
            }
            default: {
                Preconditions.checkState((boolean)false, (Object)"Must not be here");
            }
        }
    }

    static enum DecoderState {
        READ_TYPE,
        READ_MESSAGE_ID,
        READ_SENDER_HOST_LENGTH,
        READ_SENDER_HOST,
        READ_SENDER_PORT,
        READ_SUBJECT_LENGTH,
        READ_SUBJECT,
        READ_STATUS,
        READ_CONTENT_LENGTH,
        READ_CONTENT;

    }
}

