/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.agent;

import io.atomix.cluster.Node;
import io.atomix.cluster.NodeId;
import io.atomix.core.Atomix;
import io.atomix.messaging.Endpoint;
import io.atomix.rest.ManagedRestService;
import io.atomix.rest.RestService;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.action.StoreTrueArgumentAction;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomixAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomixAgent.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        List<Node> bootstrap;
        ArgumentType<Node> nodeType = new ArgumentType<Node>(){

            public Node convert(ArgumentParser argumentParser, Argument argument, String value) throws ArgumentParserException {
                String[] address = AtomixAgent.parseAddress(value);
                return Node.builder((NodeId)AtomixAgent.parseNodeId(address)).withType(Node.Type.DATA).withEndpoint(AtomixAgent.parseEndpoint(address)).build();
            }
        };
        ArgumentType<File> fileType = new ArgumentType<File>(){

            public File convert(ArgumentParser argumentParser, Argument argument, String value) throws ArgumentParserException {
                return new File(value);
            }
        };
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"AtomixServer").defaultHelp(true).description("Atomix server");
        parser.addArgument(new String[]{"node"}).type((ArgumentType)nodeType).nargs("?").metavar(new String[]{"NAME:HOST:PORT"}).setDefault((Object)Node.builder((String)"local").withType(Node.Type.DATA).withEndpoint(new Endpoint(InetAddress.getByName("127.0.0.1"), 5679)).build()).help("The local node info");
        parser.addArgument(new String[]{"--client", "-c"}).action((ArgumentAction)new StoreTrueArgumentAction()).help("Indicates this is a client node");
        parser.addArgument(new String[]{"--server", "-s"}).action((ArgumentAction)new StoreTrueArgumentAction()).help("Indicates that this is a server node");
        parser.addArgument(new String[]{"--bootstrap", "-b"}).nargs("*").type((ArgumentType)nodeType).metavar(new String[]{"NAME:HOST:PORT"}).required(false).help("Bootstraps a new cluster");
        parser.addArgument(new String[]{"--http-port", "-p"}).type(Integer.class).metavar(new String[]{"PORT"}).required(false).setDefault((Object)5678).help("An optional HTTP server port");
        parser.addArgument(new String[]{"--data-dir", "-d"}).type((ArgumentType)fileType).metavar(new String[]{"FILE"}).required(false).setDefault((Object)new File(System.getProperty("user.dir"), "data")).help("The server data directory");
        Namespace namespace = null;
        try {
            namespace = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
        }
        Node localNode = (Node)namespace.get("node");
        if (namespace.getBoolean("client").booleanValue()) {
            localNode = Node.builder((NodeId)localNode.id()).withType(Node.Type.CLIENT).withEndpoint(localNode.endpoint()).build();
        }
        if ((bootstrap = namespace.getList("bootstrap")) == null) {
            bootstrap = Collections.singletonList(localNode);
        }
        File dataDir = (File)namespace.get("data_dir");
        Integer httpPort = namespace.getInt("http_port");
        LOGGER.info("Node: {}", (Object)localNode);
        LOGGER.info("Bootstrap: {}", bootstrap);
        LOGGER.info("Data: {}", (Object)dataDir);
        Atomix atomix = Atomix.builder().withLocalNode(localNode).withBootstrapNodes(bootstrap).withDataDirectory(dataDir).build();
        atomix.start().join();
        LOGGER.info("Atomix listening at {}:{}", (Object)localNode.endpoint().host().getHostAddress(), (Object)localNode.endpoint().port());
        ManagedRestService rest = (ManagedRestService)RestService.builder().withAtomix(atomix).withEndpoint(Endpoint.from((String)localNode.endpoint().host().getHostAddress(), (int)httpPort)).build();
        rest.start().join();
        LOGGER.info("Server listening at {}:{}", (Object)localNode.endpoint().host().getHostAddress(), (Object)httpPort);
        Class<Atomix> clazz = Atomix.class;
        synchronized (Atomix.class) {
            while (atomix.isRunning()) {
                Atomix.class.wait();
            }
            // ** MonitorExit[var11_12] (shouldn't be in output)
            return;
        }
    }

    static String[] parseAddress(String address) {
        String[] parsed = address.split(":");
        if (parsed.length > 3) {
            throw new IllegalArgumentException("Malformed address " + address);
        }
        return parsed;
    }

    static NodeId parseNodeId(String[] address) {
        if (address.length == 3) {
            return NodeId.from((String)address[0]);
        }
        if (address.length == 2) {
            try {
                InetAddress.getByName(address[0]);
            }
            catch (UnknownHostException e) {
                return NodeId.from((String)address[0]);
            }
            return NodeId.from((String)AtomixAgent.parseEndpoint(address).host().getHostName());
        }
        try {
            InetAddress.getByName(address[0]);
            return NodeId.from((String)AtomixAgent.parseEndpoint(address).host().getHostName());
        }
        catch (UnknownHostException e) {
            return NodeId.from((String)address[0]);
        }
    }

    static Endpoint parseEndpoint(String[] address) {
        int port;
        String host;
        if (address.length == 3) {
            host = address[1];
            port = Integer.parseInt(address[2]);
        } else if (address.length == 2) {
            try {
                host = address[0];
                port = Integer.parseInt(address[1]);
            }
            catch (NumberFormatException e) {
                host = address[1];
                port = 5679;
            }
        } else {
            try {
                InetAddress.getByName(address[0]);
                host = address[0];
            }
            catch (UnknownHostException e) {
                host = "0.0.0.0";
            }
            port = 5679;
        }
        try {
            return new Endpoint(InetAddress.getByName(host), port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Failed to resolve host", e);
        }
    }
}

