/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.spring;

import io.atleon.core.AloStream;
import io.atleon.core.AloStreamConfig;
import io.atleon.spring.ConfiguredAloStream;
import io.atleon.spring.Contexts;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;

public class AloStreamApplicationListener<C extends AloStreamConfig>
implements ApplicationListener<ApplicationContextEvent>,
ConfiguredAloStream {
    private final AloStream<C> stream;
    private final C config;

    public AloStreamApplicationListener(AloStream<C> stream, C config) {
        this.stream = stream;
        this.config = config;
    }

    public void onApplicationEvent(ApplicationContextEvent event) {
        if (event instanceof ContextRefreshedEvent && AloStreamApplicationListener.isAutoStartEnabled(event.getApplicationContext(), this.name())) {
            this.start();
        } else if (event instanceof ContextClosedEvent) {
            this.stop();
        }
    }

    @Override
    public void start() {
        if (this.stream.state() == AloStream.State.STOPPED) {
            this.stream.start(this.config);
        }
    }

    @Override
    public void stop() {
        this.stream.stop();
    }

    @Override
    public String name() {
        return this.config.name();
    }

    @Override
    public AloStream.State state() {
        return this.stream.state();
    }

    public String toString() {
        return "AloStreamApplicationListener{stream=" + this.stream + ", config=" + this.config + '}';
    }

    private static boolean isAutoStartEnabled(ApplicationContext context, String streamName) {
        return !Contexts.isPropertySetToFalse(context, "atleon.stream." + streamName + ".auto.start.enabled");
    }
}

