/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.rabbitmq;

import com.rabbitmq.client.AMQP;
import io.atleon.core.Alo;
import io.atleon.core.SenderResult;
import io.atleon.rabbitmq.UnackedRabbitMQMessageException;
import java.util.Optional;
import reactor.rabbitmq.CorrelableOutboundMessage;
import reactor.rabbitmq.OutboundMessageResult;

public final class RabbitMQSenderResult<T>
implements SenderResult {
    private final String exchange;
    private final String routingKey;
    private final AMQP.BasicProperties properties;
    private final T correlationMetadata;
    private final boolean ack;

    private RabbitMQSenderResult(String exchange, String routingKey, AMQP.BasicProperties properties, T correlationMetadata, boolean ack) {
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.properties = properties;
        this.correlationMetadata = correlationMetadata;
        this.ack = ack;
    }

    static <T> RabbitMQSenderResult<T> fromMessageResult(OutboundMessageResult<CorrelableOutboundMessage<T>> messageResult) {
        return new RabbitMQSenderResult<Object>(((CorrelableOutboundMessage)messageResult.getOutboundMessage()).getExchange(), ((CorrelableOutboundMessage)messageResult.getOutboundMessage()).getRoutingKey(), ((CorrelableOutboundMessage)messageResult.getOutboundMessage()).getProperties(), ((CorrelableOutboundMessage)messageResult.getOutboundMessage()).getCorrelationMetadata(), messageResult.isAck());
    }

    static <T> Alo<RabbitMQSenderResult<T>> fromMessageResultOfAlo(OutboundMessageResult<CorrelableOutboundMessage<Alo<T>>> messageResult) {
        return ((Alo)((CorrelableOutboundMessage)messageResult.getOutboundMessage()).getCorrelationMetadata()).map(correlationMetadata -> new RabbitMQSenderResult<Object>(((CorrelableOutboundMessage)messageResult.getOutboundMessage()).getExchange(), ((CorrelableOutboundMessage)messageResult.getOutboundMessage()).getRoutingKey(), ((CorrelableOutboundMessage)messageResult.getOutboundMessage()).getProperties(), correlationMetadata, messageResult.isAck()));
    }

    public Optional<Throwable> failureCause() {
        return this.ack ? Optional.empty() : Optional.of(new UnackedRabbitMQMessageException());
    }

    public String toString() {
        return "RabbitMQSenderResult{exchange='" + this.exchange + '\'' + ", routingKey='" + this.routingKey + '\'' + ", properties=" + this.properties + ", correlationMetadata=" + this.correlationMetadata + ", ack=" + this.ack + '}';
    }

    public String getExchange() {
        return this.exchange;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public AMQP.BasicProperties getProperties() {
        return this.properties;
    }

    public T getCorrelationMetadata() {
        return this.correlationMetadata;
    }

    public boolean isAck() {
        return this.ack;
    }
}

