/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.rabbitmq;

import io.atleon.rabbitmq.Nackable;
import io.atleon.rabbitmq.ReceivedRabbitMQMessage;
import io.atleon.util.Configurable;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;

public interface NacknowledgerFactory<T>
extends Configurable {
    default public void configure(Map<String, ?> properties) {
    }

    public Consumer<Throwable> create(ReceivedRabbitMQMessage<T> var1, Nackable var2, Consumer<Throwable> var3);

    public static final class Nack<T>
    implements NacknowledgerFactory<T> {
        private final Logger logger;
        private final boolean requeue;

        Nack(Logger logger, boolean requeue) {
            this.logger = logger;
            this.requeue = requeue;
        }

        @Override
        public Consumer<Throwable> create(ReceivedRabbitMQMessage<T> message, Nackable nackable, Consumer<Throwable> errorEmitter) {
            return error -> {
                this.logger.warn("Nacknowledging RabbitMQ message", error);
                nackable.nack(this.requeue);
            };
        }
    }

    public static final class Emit<T>
    implements NacknowledgerFactory<T> {
        Emit() {
        }

        @Override
        public Consumer<Throwable> create(ReceivedRabbitMQMessage<T> message, Nackable nackable, Consumer<Throwable> errorEmitter) {
            return errorEmitter;
        }
    }
}

