/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import io.atleon.core.ConfigSource;
import io.atleon.rabbitmq.RabbitMQConfig;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class RabbitMQConfigSource
extends ConfigSource<RabbitMQConfig, RabbitMQConfigSource> {
    protected RabbitMQConfigSource() {
    }

    protected RabbitMQConfigSource(String name) {
        super(name);
    }

    protected RabbitMQConfigSource(Function<Map<String, Object>, Optional<String>> propertiesToName) {
        super(propertiesToName);
    }

    public static RabbitMQConfigSource unnamed() {
        return new RabbitMQConfigSource();
    }

    public static RabbitMQConfigSource named(String name) {
        return new RabbitMQConfigSource(name);
    }

    public ConnectionFactory createConnectionFactoryNow() {
        return (ConnectionFactory)this.createConnectionFactory().block();
    }

    public Mono<ConnectionFactory> createConnectionFactory() {
        return ((Mono)this.create()).map(RabbitMQConfig::buildConnectionFactory);
    }

    public RabbitMQConfigSource withHost(String host) {
        return (RabbitMQConfigSource)this.with("host", host);
    }

    public RabbitMQConfigSource withPort(int port) {
        return (RabbitMQConfigSource)this.with("port", port);
    }

    public RabbitMQConfigSource withVirtualHost(String virtualHost) {
        return (RabbitMQConfigSource)this.with("virtual.host", virtualHost);
    }

    public RabbitMQConfigSource withUsername(String username) {
        return (RabbitMQConfigSource)this.with("username", username);
    }

    public RabbitMQConfigSource withPassword(String password) {
        return (RabbitMQConfigSource)this.with("password", password);
    }

    public RabbitMQConfigSource withSsl(String ssl) {
        return (RabbitMQConfigSource)this.with("ssl", ssl);
    }

    protected RabbitMQConfigSource initializeCopy() {
        return new RabbitMQConfigSource();
    }

    protected void validateProperties(Map<String, Object> properties) {
        RabbitMQConfigSource.validateAnyNonNullProperty(properties, (String[])new String[]{"host", "hosts"});
        RabbitMQConfigSource.validateAnyNonNullProperty(properties, (String[])new String[]{"virtual.host", "vhost"});
        RabbitMQConfigSource.validateNonNullProperty(properties, (String)"username");
        RabbitMQConfigSource.validateNonNullProperty(properties, (String)"password");
    }

    protected RabbitMQConfig postProcessProperties(Map<String, Object> properties) {
        return RabbitMQConfig.create(properties);
    }
}

