/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import io.atleon.rabbitmq.AloConnectionFactory;
import io.atleon.util.ConfigLoading;
import io.atleon.util.Configurable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class RabbitMQConfig {
    private final Map<String, Object> properties;

    protected RabbitMQConfig(Map<String, Object> properties) {
        this.properties = properties;
    }

    public static RabbitMQConfig create(Map<String, Object> properties) {
        return new RabbitMQConfig(properties);
    }

    public ConnectionFactory buildConnectionFactory() {
        return AloConnectionFactory.from(this.properties);
    }

    public Map<String, Object> modifyAndGetProperties(Consumer<Map<String, Object>> modifier) {
        HashMap<String, Object> modifiedProperties = new HashMap<String, Object>(this.properties);
        modifier.accept(modifiedProperties);
        return modifiedProperties;
    }

    public <T extends Configurable> T loadConfiguredOrThrow(String property, Class<? extends T> type) {
        return (T)ConfigLoading.loadConfiguredOrThrow(this.properties, (String)property, type);
    }

    public <T extends Configurable> Optional<T> loadConfiguredWithPredefinedTypes(String key, Class<? extends T> type, Function<String, Optional<T>> predefinedTypeInstantiator) {
        return ConfigLoading.loadConfiguredWithPredefinedTypes(this.properties, (String)key, type, predefinedTypeInstantiator);
    }

    public Optional<Duration> loadDuration(String property) {
        return ConfigLoading.loadDuration(this.properties, (String)property);
    }

    public Optional<Integer> loadInt(String property) {
        return ConfigLoading.loadInt(this.properties, (String)property);
    }

    public <T extends Enum<T>> Optional<T> loadEnum(String property, Class<T> type) {
        return ConfigLoading.loadEnum(this.properties, (String)property, type);
    }
}

