/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.rabbitmq;

import com.rabbitmq.client.AMQP;
import io.atleon.rabbitmq.RabbitMQMessage;
import io.atleon.rabbitmq.RabbitMQMessageCreator;
import java.util.UUID;

public abstract class AbstractRabbitMQMessageCreator<T>
implements RabbitMQMessageCreator<T> {
    private final AMQP.BasicProperties initialProperties;

    public AbstractRabbitMQMessageCreator(AMQP.BasicProperties initialProperties) {
        this.initialProperties = initialProperties;
    }

    @Override
    public RabbitMQMessage<T> apply(T body) {
        return new RabbitMQMessage<T>(this.extractExchange(body), this.extractRoutingKey(body), this.createMessagePropertiesBuilder(body).build(), body);
    }

    protected abstract String extractExchange(T var1);

    protected abstract String extractRoutingKey(T var1);

    protected AMQP.BasicProperties.Builder createMessagePropertiesBuilder(T body) {
        return this.initialProperties.builder().messageId(UUID.randomUUID().toString());
    }
}

