/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.rabbitmq;

import java.util.Collections;
import java.util.Map;

public final class QueueBinding {
    private final String queue;
    private final String exchange;
    private final String routingKey;
    private final Map<String, Object> arguments;

    private QueueBinding(String queue, String exchange, String routingKey) {
        this(queue, exchange, routingKey, Collections.emptyMap());
    }

    private QueueBinding(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        this.queue = queue;
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.arguments = arguments;
    }

    public static QueueToBind forQueue(String queue) {
        return new QueueToBind(queue);
    }

    public QueueBinding arguments(Map<String, Object> arguments) {
        return new QueueBinding(this.queue, this.exchange, this.routingKey, arguments);
    }

    public String getQueue() {
        return this.queue;
    }

    public String getExchange() {
        return this.exchange;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public static final class QueueAndExchangeToBind {
        private final String queue;
        private final String exchange;

        private QueueAndExchangeToBind(String queue, String exchange) {
            this.queue = queue;
            this.exchange = exchange;
        }

        public QueueBinding usingRoutingKey(String routingKey) {
            return new QueueBinding(this.queue, this.exchange, routingKey);
        }

        public QueueBinding usingEmptyRoutingKey() {
            return new QueueBinding(this.queue, this.exchange, "");
        }
    }

    public static final class QueueToBind {
        private final String queue;

        private QueueToBind(String queue) {
            this.queue = queue;
        }

        public QueueAndExchangeToBind toExchange(String exchange) {
            return new QueueAndExchangeToBind(this.queue, exchange);
        }
    }
}

