/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import io.atleon.util.ConfigLoading;
import io.atleon.util.Configurable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class RabbitMQConfig {
    private final ConnectionFactory connectionFactory;
    private final Map<String, Object> properties;

    public RabbitMQConfig(ConnectionFactory connectionFactory, Map<String, Object> properties) {
        this.connectionFactory = connectionFactory;
        this.properties = properties;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public Map<String, Object> modifyAndGetProperties(Consumer<Map<String, Object>> modifier) {
        HashMap<String, Object> modifiedProperties = new HashMap<String, Object>(this.properties);
        modifier.accept(modifiedProperties);
        return modifiedProperties;
    }

    public <T extends Configurable> T loadConfiguredOrThrow(String property, Class<? extends T> type) {
        return (T)ConfigLoading.loadConfiguredOrThrow(this.properties, (String)property, type);
    }

    public <T extends Configurable> Optional<T> loadConfiguredWithPredefinedTypes(String key, Class<? extends T> type, Function<String, Optional<T>> predefinedTypeInstantiator) {
        return ConfigLoading.loadConfiguredWithPredefinedTypes(this.properties, (String)key, type, predefinedTypeInstantiator);
    }

    public Optional<Integer> loadInt(String property) {
        return ConfigLoading.loadInt(this.properties, (String)property);
    }

    public <T> Optional<T> loadParseable(String property, Class<T> type, Function<? super String, T> parser) {
        return ConfigLoading.loadParseable(this.properties, (String)property, type, parser);
    }
}

