/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import io.atleon.core.ConfigSource;
import io.atleon.rabbitmq.RabbitMQConfig;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class RabbitMQConfigSource
extends ConfigSource<RabbitMQConfig, RabbitMQConfigSource> {
    public static final String HOST_PROPERTY = "host";
    public static final String PORT_PROPERTY = "port";
    public static final String VIRTUAL_HOST_PROPERTY = "virtual-host";
    public static final String USERNAME_PROPERTY = "username";
    public static final String PASSWORD_PROPERTY = "password";
    public static final String SSL_PROPERTY = "ssl";
    public static final String DISABLED_CONFIG = "disabled";

    protected RabbitMQConfigSource() {
    }

    protected RabbitMQConfigSource(String name) {
        super(name);
    }

    protected RabbitMQConfigSource(Function<Map<String, Object>, Optional<String>> propertiesToName) {
        super(propertiesToName);
    }

    public static RabbitMQConfigSource named(String name) {
        return new RabbitMQConfigSource(name);
    }

    public static RabbitMQConfigSource unnamed() {
        return new RabbitMQConfigSource();
    }

    public RabbitMQConfigSource withHost(String host) {
        return (RabbitMQConfigSource)this.with(HOST_PROPERTY, host);
    }

    public RabbitMQConfigSource withPort(int port) {
        return (RabbitMQConfigSource)this.with(PORT_PROPERTY, port);
    }

    public RabbitMQConfigSource withVirtualHost(String virtualHost) {
        return (RabbitMQConfigSource)this.with(VIRTUAL_HOST_PROPERTY, virtualHost);
    }

    public RabbitMQConfigSource withUsername(String username) {
        return (RabbitMQConfigSource)this.with(USERNAME_PROPERTY, username);
    }

    public RabbitMQConfigSource withPassword(String password) {
        return (RabbitMQConfigSource)this.with(PASSWORD_PROPERTY, password);
    }

    public RabbitMQConfigSource withSsl(String ssl) {
        return (RabbitMQConfigSource)this.with(SSL_PROPERTY, ssl);
    }

    protected RabbitMQConfigSource initializeCopy() {
        return new RabbitMQConfigSource();
    }

    protected void validateProperties(Map<String, Object> properties) {
        this.validateAddressProperties(properties);
        RabbitMQConfigSource.validateNonNullProperty(properties, (String)VIRTUAL_HOST_PROPERTY);
        RabbitMQConfigSource.validateNonNullProperty(properties, (String)USERNAME_PROPERTY);
        RabbitMQConfigSource.validateNonNullProperty(properties, (String)PASSWORD_PROPERTY);
    }

    protected RabbitMQConfig postProcessProperties(Map<String, Object> properties) {
        return new RabbitMQConfig(RabbitMQConfigSource.createConnectionFactory(properties), properties);
    }

    protected void validateAddressProperties(Map<String, Object> properties) {
        RabbitMQConfigSource.validateNonNullProperty(properties, (String)HOST_PROPERTY);
        RabbitMQConfigSource.validateNonNullProperty(properties, (String)PORT_PROPERTY);
    }

    private static ConnectionFactory createConnectionFactory(Map<String, Object> properties) {
        try {
            ConnectionFactory connectionFactory = new ConnectionFactory();
            connectionFactory.setHost(Objects.toString(properties.get(HOST_PROPERTY)));
            connectionFactory.setPort(Integer.parseInt(Objects.toString(properties.get(PORT_PROPERTY))));
            connectionFactory.setVirtualHost(Objects.toString(properties.get(VIRTUAL_HOST_PROPERTY)));
            connectionFactory.setUsername(Objects.toString(properties.get(USERNAME_PROPERTY)));
            connectionFactory.setPassword(Objects.toString(properties.get(PASSWORD_PROPERTY)));
            if (!Objects.toString(properties.get(SSL_PROPERTY), DISABLED_CONFIG).equals(DISABLED_CONFIG)) {
                connectionFactory.useSslProtocol(Objects.toString(properties.get(SSL_PROPERTY)));
            }
            return connectionFactory;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create ConnectionFactory: " + e);
        }
    }
}

