/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.MessageProperties;
import io.atleon.rabbitmq.AbstractRabbitMQMessageCreator;
import java.util.Objects;
import java.util.function.Function;

public final class DefaultRabbitMQMessageCreator<T>
extends AbstractRabbitMQMessageCreator<T> {
    private final Function<? super T, String> exchangeExtractor;
    private final Function<? super T, String> routingKeyExtractor;

    public DefaultRabbitMQMessageCreator(AMQP.BasicProperties initialProperties, Function<? super T, String> exchangeExtractor, Function<? super T, String> routingKeyExtractor) {
        super(initialProperties);
        this.exchangeExtractor = exchangeExtractor;
        this.routingKeyExtractor = routingKeyExtractor;
    }

    public static <T> DefaultRabbitMQMessageCreator<T> minimalBasicToDefaultExchange(String queue) {
        return new DefaultRabbitMQMessageCreator<Object>(MessageProperties.MINIMAL_BASIC, t -> "", t -> queue);
    }

    public static <T> DefaultRabbitMQMessageCreator<T> minimalBasicToDefaultExchange(Function<? super T, String> queueExtractor) {
        return new DefaultRabbitMQMessageCreator<T>(MessageProperties.MINIMAL_BASIC, t -> "", queueExtractor);
    }

    public static <T> DefaultRabbitMQMessageCreator<T> minimalBasic(String exchange, String routingKey) {
        return new DefaultRabbitMQMessageCreator<Object>(MessageProperties.MINIMAL_BASIC, t -> exchange, t -> routingKey);
    }

    public static <T> DefaultRabbitMQMessageCreator<T> minimalBasic(String exchange, Function<? super T, String> routingKeyExtractor) {
        return new DefaultRabbitMQMessageCreator<T>(MessageProperties.MINIMAL_BASIC, t -> exchange, routingKeyExtractor);
    }

    public static <T> DefaultRabbitMQMessageCreator<T> toDefaultExchange(AMQP.BasicProperties properties, String queue) {
        return new DefaultRabbitMQMessageCreator<Object>(properties, t -> "", t -> queue);
    }

    public static <T> DefaultRabbitMQMessageCreator<T> toDefaultExchange(AMQP.BasicProperties properties, Function<? super T, String> queueExtractor) {
        return new DefaultRabbitMQMessageCreator<T>(properties, t -> "", queueExtractor);
    }

    public static <T> DefaultRabbitMQMessageCreator<T> of(AMQP.BasicProperties properties, String exchange, String routingKey) {
        return new DefaultRabbitMQMessageCreator<Object>(properties, t -> exchange, t -> routingKey);
    }

    public static <T> DefaultRabbitMQMessageCreator<T> of(AMQP.BasicProperties properties, String exchange, Function<? super T, String> routingKeyExtractor) {
        return new DefaultRabbitMQMessageCreator<T>(properties, t -> exchange, routingKeyExtractor);
    }

    @Override
    protected String extractExchange(T t) {
        return Objects.toString(this.exchangeExtractor.apply(t));
    }

    @Override
    protected String extractRoutingKey(T t) {
        return Objects.toString(this.routingKeyExtractor.apply(t));
    }
}

