/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.micrometer;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

final class TypeKey<T extends Enum<T>, K> {
    private final T type;
    private final K key;

    public TypeKey(T type) {
        this(type, null);
    }

    public TypeKey(T type, K key) {
        this.type = type;
        this.key = key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeKey typeKey = (TypeKey)o;
        return ((Enum)this.type).equals(typeKey.type) && Objects.equals(this.key, typeKey.key);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.key);
    }

    public T type() {
        return this.type;
    }

    public String typeName() {
        return ((Enum)this.type).name();
    }

    public <U> Optional<U> mapKey(Function<? super K, ? extends U> mapper) {
        return this.key == null ? Optional.empty() : Optional.of(mapper.apply(this.key));
    }

    public K key() {
        return this.key;
    }
}

