/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.micrometer;

import io.atleon.micrometer.MeterKey;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MeterFacade {
    private final MeterRegistry registry;
    private final Map<MeterKey, Counter> counters = new ConcurrentHashMap<MeterKey, Counter>();
    private final Map<MeterKey, Timer> timers = new ConcurrentHashMap<MeterKey, Timer>();

    private MeterFacade(MeterRegistry registry) {
        this.registry = registry;
    }

    public static MeterFacade global() {
        return new MeterFacade((MeterRegistry)Metrics.globalRegistry);
    }

    public static MeterFacade wrap(MeterRegistry registry) {
        return new MeterFacade(registry);
    }

    public Counter counter(String name, Tags tags) {
        return this.counters.computeIfAbsent(new MeterKey(name, tags), this::newCounter);
    }

    public Timer timer(String name, Tags tags) {
        return this.timers.computeIfAbsent(new MeterKey(name, tags), this::newTimer);
    }

    private Counter newCounter(MeterKey meterKey) {
        return this.registry.counter(meterKey.getName(), meterKey.getTags());
    }

    private Timer newTimer(MeterKey meterKey) {
        return this.registry.timer(meterKey.getName(), meterKey.getTags());
    }
}

