/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.kafka;

import io.atleon.kafka.OffsetRange;
import java.time.Instant;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;

public abstract class OffsetCriteria {
    private OffsetCriteria() {
    }

    public static OffsetCriteria earliest() {
        return new Earliest();
    }

    public static OffsetCriteria latest() {
        return new Latest();
    }

    public static OffsetCriteria timestamp(Instant instant) {
        return new Timestamp(instant.toEpochMilli());
    }

    public static OffsetCriteria timestamp(long epochMillis) {
        return new Timestamp(epochMillis);
    }

    public static OffsetCriteria consumerGroup(String groupId) {
        return new ConsumerGroup(groupId, OffsetResetStrategy.NONE);
    }

    public static OffsetCriteria consumerGroup(String groupId, OffsetResetStrategy resetStrategy) {
        return new ConsumerGroup(groupId, resetStrategy);
    }

    static OffsetCriteria raw(long offset) {
        return new Raw(offset);
    }

    public OffsetRange asRange() {
        return this.to(this);
    }

    public OffsetRange to(OffsetCriteria maxInclusive) {
        return OffsetRange.of(this, maxInclusive);
    }

    public static final class Raw
    extends OffsetCriteria {
        private final long offset;

        private Raw(long offset) {
            this.offset = offset;
        }

        public long offset() {
            return this.offset;
        }
    }

    public static final class ConsumerGroup
    extends OffsetCriteria {
        private final String groupId;
        private final OffsetResetStrategy resetStrategy;

        private ConsumerGroup(String groupId, OffsetResetStrategy resetStrategy) {
            this.groupId = groupId;
            this.resetStrategy = resetStrategy;
        }

        public String groupId() {
            return this.groupId;
        }

        public OffsetResetStrategy resetStrategy() {
            return this.resetStrategy;
        }
    }

    public static final class Timestamp
    extends OffsetCriteria {
        private final long epochMillis;

        private Timestamp(long epochMillis) {
            this.epochMillis = epochMillis;
        }

        public long epochMillis() {
            return this.epochMillis;
        }
    }

    public static final class Latest
    extends OffsetCriteria {
        private Latest() {
        }
    }

    public static final class Earliest
    extends OffsetCriteria {
        private Earliest() {
        }
    }
}

