/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.kafka;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.UUID;

final class MachineData {
    private final UUID id;
    private final long birthTime;

    MachineData(UUID id, long birthTime) {
        this.id = id;
        this.birthTime = birthTime;
    }

    public static MachineData birth() {
        return new MachineData(UUID.randomUUID(), System.currentTimeMillis());
    }

    public static MachineData fromByteBuffer(ByteBuffer buffer) {
        long idMostSignificantBits = MachineData.extractLong(buffer);
        long idLeastSignificantBits = MachineData.extractLong(buffer);
        long birthTime = MachineData.extractLong(buffer);
        return new MachineData(new UUID(idMostSignificantBits, idLeastSignificantBits), birthTime);
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(24);
        byteBuffer.putLong(this.id.getMostSignificantBits());
        byteBuffer.putLong(this.id.getLeastSignificantBits());
        byteBuffer.putLong(this.birthTime);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineData that = (MachineData)o;
        return this.birthTime == that.birthTime && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.birthTime);
    }

    public String toString() {
        return "MachineData{id=" + this.id + ", birthTime=" + this.birthTime + '}';
    }

    public UUID id() {
        return this.id;
    }

    public long birthTime() {
        return this.birthTime;
    }

    private static Long extractLong(ByteBuffer byteBuffer) {
        ByteBuffer longBuffer = ByteBuffer.allocate(8);
        longBuffer.putLong(byteBuffer.getLong());
        ((Buffer)Buffer.class.cast(longBuffer)).flip();
        return longBuffer.getLong();
    }
}

